/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.json;

import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeConvertingCodec;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;

public class JsonNodeToStringCodec
extends JsonNodeConvertingCodec<String> {
    private final ObjectMapper objectMapper;

    public JsonNodeToStringCodec(TypeCodec<String> innerCodec, ObjectMapper objectMapper, List<String> nullStrings) {
        super(innerCodec, nullStrings);
        this.objectMapper = objectMapper;
    }

    public String externalToInternal(JsonNode node) {
        if (this.isNull(node)) {
            return null;
        }
        if (node.isContainerNode()) {
            try {
                return this.objectMapper.writeValueAsString((Object)node);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Cannot deserialize node " + node, e);
            }
        }
        return node.asText();
    }

    public JsonNode internalToExternal(String value) {
        if (value == null) {
            return null;
        }
        return this.objectMapper.getNodeFactory().textNode(value);
    }
}

