/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.json;

import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.dsbulk.codecs.api.format.temporal.NumericTemporalFormat;
import com.datastax.oss.dsbulk.codecs.api.format.temporal.TemporalFormat;
import com.datastax.oss.dsbulk.codecs.text.json.JsonCodecUtils;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeConvertingCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.temporal.TemporalAccessor;
import java.util.List;

public abstract class JsonNodeToTemporalCodec<T extends TemporalAccessor>
extends JsonNodeConvertingCodec<T> {
    final TemporalFormat temporalFormat;

    JsonNodeToTemporalCodec(TypeCodec<T> targetCodec, TemporalFormat temporalFormat, List<String> nullStrings) {
        super(targetCodec, nullStrings);
        this.temporalFormat = temporalFormat;
    }

    public JsonNode internalToExternal(T value) {
        if (value == null) {
            return null;
        }
        if (this.temporalFormat instanceof NumericTemporalFormat) {
            Number n = ((NumericTemporalFormat)this.temporalFormat).temporalToNumber(value);
            if (n == null) {
                return null;
            }
            if (n instanceof Byte) {
                return JsonCodecUtils.JSON_NODE_FACTORY.numberNode((Byte)n);
            }
            if (n instanceof Short) {
                return JsonCodecUtils.JSON_NODE_FACTORY.numberNode((Short)n);
            }
            if (n instanceof Integer) {
                return JsonCodecUtils.JSON_NODE_FACTORY.numberNode((Integer)n);
            }
            if (n instanceof Long) {
                return JsonCodecUtils.JSON_NODE_FACTORY.numberNode((Long)n);
            }
            if (n instanceof Float) {
                return JsonCodecUtils.JSON_NODE_FACTORY.numberNode((Float)n);
            }
            if (n instanceof Double) {
                return JsonCodecUtils.JSON_NODE_FACTORY.numberNode((Double)n);
            }
            if (n instanceof BigInteger) {
                return JsonCodecUtils.JSON_NODE_FACTORY.numberNode((BigInteger)n);
            }
            if (n instanceof BigDecimal) {
                return JsonCodecUtils.JSON_NODE_FACTORY.numberNode((BigDecimal)n);
            }
            return JsonCodecUtils.JSON_NODE_FACTORY.textNode(n.toString());
        }
        return JsonCodecUtils.JSON_NODE_FACTORY.textNode(this.temporalFormat.format(value));
    }

    TemporalAccessor parseTemporalAccessor(JsonNode node) {
        if (this.isNullOrEmpty(node)) {
            return null;
        }
        if (node instanceof NumericNode && this.temporalFormat instanceof NumericTemporalFormat) {
            Number n = node.numberValue();
            return ((NumericTemporalFormat)this.temporalFormat).numberToTemporal(n);
        }
        String s = node.asText();
        return this.temporalFormat.parse(s);
    }
}

