/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.json;

import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeConvertingCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonSchemaMismatchException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.List;

public class JsonNodeToTupleCodec
extends JsonNodeConvertingCodec<TupleValue> {
    private final TupleType definition;
    private final List<ConvertingCodec<JsonNode, Object>> eltCodecs;
    private final ObjectMapper objectMapper;
    private final boolean allowExtraFields;
    private final boolean allowMissingFields;

    public JsonNodeToTupleCodec(TypeCodec<TupleValue> tupleCodec, List<ConvertingCodec<JsonNode, Object>> eltCodecs, ObjectMapper objectMapper, List<String> nullStrings, boolean allowExtraFields, boolean allowMissingFields) {
        super(tupleCodec, nullStrings);
        this.eltCodecs = eltCodecs;
        this.definition = (TupleType)tupleCodec.getCqlType();
        this.objectMapper = objectMapper;
        this.allowExtraFields = allowExtraFields;
        this.allowMissingFields = allowMissingFields;
    }

    public TupleValue externalToInternal(JsonNode node) {
        if (this.isNullOrEmpty(node)) {
            return null;
        }
        if (!node.isArray()) {
            throw new IllegalArgumentException("Expecting ARRAY node, got " + node.getNodeType());
        }
        int tupleSize = this.definition.getComponentTypes().size();
        int nodeSize = node.size();
        if (nodeSize > tupleSize && !this.allowExtraFields) {
            throw JsonSchemaMismatchException.arraySizeGreaterThanTupleSize(tupleSize, nodeSize);
        }
        if (nodeSize < tupleSize && !this.allowMissingFields) {
            throw JsonSchemaMismatchException.arraySizeLesserThanTupleSize(tupleSize, nodeSize);
        }
        TupleValue tuple = this.definition.newValue();
        for (int i = 0; i < tupleSize && i < nodeSize; ++i) {
            ConvertingCodec<JsonNode, Object> eltCodec = this.eltCodecs.get(i);
            Object o = eltCodec.externalToInternal((Object)node.get(i));
            tuple = (TupleValue)tuple.set(i, o, eltCodec.getInternalJavaType());
        }
        return tuple;
    }

    public JsonNode internalToExternal(TupleValue tuple) {
        if (tuple == null) {
            return null;
        }
        ArrayNode root = this.objectMapper.createArrayNode();
        int size = this.definition.getComponentTypes().size();
        for (int i = 0; i < size; ++i) {
            ConvertingCodec<JsonNode, Object> eltCodec = this.eltCodecs.get(i);
            Object o = tuple.get(i, eltCodec.getInternalJavaType());
            JsonNode element = (JsonNode)eltCodec.internalToExternal(o);
            root.add(element);
        }
        return root;
    }
}

