/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.json;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterators;
import com.datastax.oss.driver.shaded.guava.common.collect.Sets;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeConvertingCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonSchemaMismatchException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class JsonNodeToUDTCodec
extends JsonNodeConvertingCodec<UdtValue> {
    private final Map<CqlIdentifier, ConvertingCodec<JsonNode, Object>> fieldCodecs;
    private final UserDefinedType definition;
    private final ObjectMapper objectMapper;
    private final boolean allowExtraFields;
    private final boolean allowMissingFields;

    public JsonNodeToUDTCodec(TypeCodec<UdtValue> udtCodec, Map<CqlIdentifier, ConvertingCodec<JsonNode, Object>> fieldCodecs, ObjectMapper objectMapper, List<String> nullStrings, boolean allowExtraFields, boolean allowMissingFields) {
        super(udtCodec, nullStrings);
        this.fieldCodecs = fieldCodecs;
        this.definition = (UserDefinedType)udtCodec.getCqlType();
        this.objectMapper = objectMapper;
        this.allowExtraFields = allowExtraFields;
        this.allowMissingFields = allowMissingFields;
    }

    public UdtValue externalToInternal(JsonNode node) {
        if (this.isNullOrEmpty(node)) {
            return null;
        }
        if (!node.isObject() && !node.isArray()) {
            throw new IllegalArgumentException("Expecting OBJECT or ARRAY node, got " + node.getNodeType());
        }
        if (node.size() == 0 && this.allowMissingFields) {
            return this.definition.newValue();
        }
        UdtValue value = this.definition.newValue();
        if (node.isObject()) {
            this.checkJsonObject(node);
            for (CqlIdentifier field : this.definition.getFieldNames()) {
                String name = field.asInternal();
                if (!node.has(name)) continue;
                ConvertingCodec<JsonNode, Object> fieldCodec = this.fieldCodecs.get(field);
                Object o = fieldCodec.externalToInternal((Object)node.get(name));
                value = (UdtValue)value.set(field, o, fieldCodec.getInternalJavaType());
            }
        } else {
            this.checkJsonArray(node);
            Iterator fields = this.definition.getFieldNames().iterator();
            for (int i = 0; i < node.size() && fields.hasNext(); ++i) {
                JsonNode element = node.get(i);
                CqlIdentifier field = (CqlIdentifier)fields.next();
                ConvertingCodec<JsonNode, Object> fieldCodec = this.fieldCodecs.get(field);
                Object o = fieldCodec.externalToInternal((Object)element);
                value = (UdtValue)value.set(i, o, fieldCodec.getInternalJavaType());
            }
        }
        return value;
    }

    private void checkJsonObject(JsonNode node) {
        Set udtFieldNames = this.definition.getFieldNames().stream().map(CqlIdentifier::asInternal).collect(Collectors.toCollection(LinkedHashSet::new));
        LinkedHashSet nodeFieldNames = new LinkedHashSet();
        Iterators.addAll(nodeFieldNames, (Iterator)node.fieldNames());
        if (!udtFieldNames.equals(nodeFieldNames)) {
            boolean hasMissing;
            Sets.SetView extraneous = Sets.difference(nodeFieldNames, (Set)udtFieldNames);
            Sets.SetView missing = Sets.difference((Set)udtFieldNames, nodeFieldNames);
            boolean hasExtras = !this.allowExtraFields && !extraneous.isEmpty();
            boolean bl = hasMissing = !this.allowMissingFields && !missing.isEmpty();
            if (hasMissing && hasExtras) {
                throw JsonSchemaMismatchException.objectHasMissingAndExtraneousFields((Set<String>)extraneous, (Set<String>)missing);
            }
            if (hasExtras) {
                throw JsonSchemaMismatchException.objectHasExtraneousFields((Set<String>)extraneous);
            }
            if (hasMissing) {
                throw JsonSchemaMismatchException.objectHasMissingFields((Set<String>)missing);
            }
        }
    }

    private void checkJsonArray(JsonNode node) {
        int udtSize = this.definition.getFieldNames().size();
        int nodeSize = node.size();
        if (nodeSize > udtSize && !this.allowExtraFields) {
            throw JsonSchemaMismatchException.arraySizeGreaterThanUDTSize(udtSize, nodeSize);
        }
        if (nodeSize < udtSize && !this.allowMissingFields) {
            throw JsonSchemaMismatchException.arraySizeLesserThanUDTSize(udtSize, nodeSize);
        }
    }

    public JsonNode internalToExternal(UdtValue value) {
        if (value == null) {
            return null;
        }
        ObjectNode root = this.objectMapper.createObjectNode();
        for (CqlIdentifier field : this.definition.getFieldNames()) {
            ConvertingCodec<JsonNode, Object> eltCodec = this.fieldCodecs.get(field);
            Object o = value.get(field, eltCodec.getInternalJavaType());
            JsonNode node = (JsonNode)eltCodec.internalToExternal(o);
            root.set(field.asInternal(), node);
        }
        return root;
    }
}

