/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.json;

import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import com.datastax.oss.dsbulk.codecs.api.util.CodecUtils;
import com.datastax.oss.dsbulk.codecs.api.util.TimeUUIDGenerator;
import com.datastax.oss.dsbulk.codecs.text.json.JsonCodecUtils;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeConvertingCodec;
import com.fasterxml.jackson.databind.JsonNode;
import java.time.Instant;
import java.util.List;
import java.util.UUID;

public class JsonNodeToUUIDCodec
extends JsonNodeConvertingCodec<UUID> {
    private final ConvertingCodec<String, Instant> instantCodec;
    private final TimeUUIDGenerator generator;

    public JsonNodeToUUIDCodec(TypeCodec<UUID> targetCodec, ConvertingCodec<String, Instant> instantCodec, TimeUUIDGenerator generator, List<String> nullStrings) {
        super(targetCodec, nullStrings);
        this.instantCodec = instantCodec;
        this.generator = generator;
    }

    public UUID externalToInternal(JsonNode node) {
        if (this.isNullOrEmpty(node)) {
            return null;
        }
        return CodecUtils.parseUUID((String)node.asText(), this.instantCodec, (TimeUUIDGenerator)this.generator);
    }

    public JsonNode internalToExternal(UUID value) {
        return value == null ? null : JsonCodecUtils.JSON_NODE_FACTORY.textNode(value.toString());
    }
}

