/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.json;

import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonCodecUtils;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeConvertingCodec;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;

public class JsonNodeToUnknownTypeCodec<T>
extends JsonNodeConvertingCodec<T> {
    public JsonNodeToUnknownTypeCodec(TypeCodec<T> targetCodec, List<String> nullStrings) {
        super(targetCodec, nullStrings);
    }

    public T externalToInternal(JsonNode node) {
        if (this.isNullOrEmpty(node)) {
            return null;
        }
        return (T)this.getInternalCodec().parse(node.asText());
    }

    public JsonNode internalToExternal(T o) {
        if (o == null) {
            return null;
        }
        String s = this.getInternalCodec().format(o);
        if (s.equalsIgnoreCase("NULL")) {
            return null;
        }
        return JsonCodecUtils.JSON_NODE_FACTORY.textNode(s);
    }
}

