/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.json;

import com.datastax.oss.driver.api.core.data.CqlVector;
import com.datastax.oss.driver.internal.core.type.codec.CqlVectorCodec;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeConvertingCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.Iterator;
import java.util.List;

public class JsonNodeToVectorCodec<SubtypeT>
extends JsonNodeConvertingCodec<CqlVector<SubtypeT>> {
    private final ConvertingCodec<JsonNode, SubtypeT> subtypeCodec;
    private final ObjectMapper objectMapper;

    public JsonNodeToVectorCodec(CqlVectorCodec<SubtypeT> targetCodec, ConvertingCodec<JsonNode, SubtypeT> subtypeCodec, ObjectMapper objectMapper, List<String> nullStrings) {
        super(targetCodec, nullStrings);
        this.subtypeCodec = subtypeCodec;
        this.objectMapper = objectMapper;
    }

    public CqlVector<SubtypeT> externalToInternal(JsonNode jsonNode) {
        if (jsonNode == null || !jsonNode.isArray()) {
            return null;
        }
        CqlVector.Builder builder = CqlVector.builder();
        Iterator it = jsonNode.elements();
        while (it.hasNext()) {
            builder.add(this.subtypeCodec.externalToInternal((Object)((JsonNode)it.next())));
        }
        return builder.build();
    }

    public JsonNode internalToExternal(CqlVector<SubtypeT> value) {
        if (value == null) {
            return null;
        }
        ArrayNode root = this.objectMapper.createArrayNode();
        for (Object element : value.getValues()) {
            root.add((JsonNode)this.subtypeCodec.internalToExternal(element));
        }
        return root;
    }
}

