/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.json.dse;

import com.datastax.dse.driver.api.core.data.geometry.Geometry;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.dsbulk.codecs.api.format.geo.GeoFormat;
import com.datastax.oss.dsbulk.codecs.api.format.geo.JsonGeoFormat;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeConvertingCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.List;

public abstract class JsonNodeToGeometryCodec<T extends Geometry>
extends JsonNodeConvertingCodec<T> {
    protected final ObjectMapper objectMapper;
    protected final GeoFormat geoFormat;

    protected JsonNodeToGeometryCodec(TypeCodec<T> targetCodec, ObjectMapper objectMapper, GeoFormat geoFormat, List<String> nullStrings) {
        super(targetCodec, nullStrings);
        this.objectMapper = objectMapper;
        this.geoFormat = geoFormat;
    }

    public T externalToInternal(JsonNode node) {
        if (this.isNullOrEmpty(node)) {
            return null;
        }
        try {
            if (node.isObject()) {
                String s = this.objectMapper.writeValueAsString((Object)node);
                return this.parseGeometry(s);
            }
            if (node.isBinary()) {
                byte[] bytes = node.binaryValue();
                return this.parseGeometry(bytes);
            }
            String s = node.asText();
            return this.parseGeometry(s);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot deserialize node " + node, e);
        }
    }

    protected abstract T parseGeometry(@NonNull String var1);

    protected abstract T parseGeometry(@NonNull byte[] var1);

    public JsonNode internalToExternal(T value) {
        if (value == null) {
            return null;
        }
        try {
            String s = this.geoFormat.format(value);
            if (this.geoFormat == JsonGeoFormat.INSTANCE) {
                return this.objectMapper.readTree(s);
            }
            return this.objectMapper.getNodeFactory().textNode(s);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot serialize value " + value, e);
        }
    }
}

