/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.string;

import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import java.util.List;

public abstract class StringConvertingCodec<T>
extends ConvertingCodec<String, T> {
    private final List<String> nullStrings;

    protected StringConvertingCodec(TypeCodec<T> targetCodec, List<String> nullStrings) {
        super(targetCodec, String.class);
        this.nullStrings = nullStrings;
    }

    protected boolean isNull(String s) {
        return s == null || this.nullStrings.contains(s);
    }

    protected boolean isNullOrEmpty(String s) {
        return this.isNull(s) || s.isEmpty();
    }

    protected String nullString() {
        return this.nullStrings.isEmpty() ? null : this.nullStrings.get(0);
    }
}

