/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.string;

import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.CqlVectorType;
import com.datastax.oss.driver.api.core.type.CustomType;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.CodecNotFoundException;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CqlVectorCodec;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.dsbulk.codecs.api.ConversionContext;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodecFactory;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodecProvider;
import com.datastax.oss.dsbulk.codecs.api.format.binary.BinaryFormat;
import com.datastax.oss.dsbulk.codecs.api.format.geo.GeoFormat;
import com.datastax.oss.dsbulk.codecs.api.format.temporal.TemporalFormat;
import com.datastax.oss.dsbulk.codecs.api.util.OverflowStrategy;
import com.datastax.oss.dsbulk.codecs.api.util.TimeUUIDGenerator;
import com.datastax.oss.dsbulk.codecs.text.json.JsonCodecUtils;
import com.datastax.oss.dsbulk.codecs.text.string.StringToBigDecimalCodec;
import com.datastax.oss.dsbulk.codecs.text.string.StringToBigIntegerCodec;
import com.datastax.oss.dsbulk.codecs.text.string.StringToBlobCodec;
import com.datastax.oss.dsbulk.codecs.text.string.StringToBooleanCodec;
import com.datastax.oss.dsbulk.codecs.text.string.StringToByteCodec;
import com.datastax.oss.dsbulk.codecs.text.string.StringToDoubleCodec;
import com.datastax.oss.dsbulk.codecs.text.string.StringToDurationCodec;
import com.datastax.oss.dsbulk.codecs.text.string.StringToFloatCodec;
import com.datastax.oss.dsbulk.codecs.text.string.StringToInetAddressCodec;
import com.datastax.oss.dsbulk.codecs.text.string.StringToInstantCodec;
import com.datastax.oss.dsbulk.codecs.text.string.StringToIntegerCodec;
import com.datastax.oss.dsbulk.codecs.text.string.StringToListCodec;
import com.datastax.oss.dsbulk.codecs.text.string.StringToLocalDateCodec;
import com.datastax.oss.dsbulk.codecs.text.string.StringToLocalTimeCodec;
import com.datastax.oss.dsbulk.codecs.text.string.StringToLongCodec;
import com.datastax.oss.dsbulk.codecs.text.string.StringToMapCodec;
import com.datastax.oss.dsbulk.codecs.text.string.StringToSetCodec;
import com.datastax.oss.dsbulk.codecs.text.string.StringToShortCodec;
import com.datastax.oss.dsbulk.codecs.text.string.StringToStringCodec;
import com.datastax.oss.dsbulk.codecs.text.string.StringToTupleCodec;
import com.datastax.oss.dsbulk.codecs.text.string.StringToUDTCodec;
import com.datastax.oss.dsbulk.codecs.text.string.StringToUUIDCodec;
import com.datastax.oss.dsbulk.codecs.text.string.StringToUnknownTypeCodec;
import com.datastax.oss.dsbulk.codecs.text.string.StringToVectorCodec;
import com.datastax.oss.dsbulk.codecs.text.string.dse.StringToDateRangeCodec;
import com.datastax.oss.dsbulk.codecs.text.string.dse.StringToLineStringCodec;
import com.datastax.oss.dsbulk.codecs.text.string.dse.StringToPointCodec;
import com.datastax.oss.dsbulk.codecs.text.string.dse.StringToPolygonCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.netty.util.concurrent.FastThreadLocal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringConvertingCodecProvider
implements ConvertingCodecProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringConvertingCodecProvider.class);
    private static final String LINE_STRING_CLASS_NAME = "org.apache.cassandra.db.marshal.LineStringType";
    private static final String POINT_CLASS_NAME = "org.apache.cassandra.db.marshal.PointType";
    private static final String POLYGON_CLASS_NAME = "org.apache.cassandra.db.marshal.PolygonType";
    private static final String DATE_RANGE_CLASS_NAME = "org.apache.cassandra.db.marshal.DateRangeType";

    @NonNull
    public Optional<ConvertingCodec<?, ?>> maybeProvide(@NonNull DataType cqlType, @NonNull GenericType<?> externalJavaType, @NonNull ConvertingCodecFactory codecFactory, boolean rootCodec) {
        if (!externalJavaType.equals((Object)GenericType.STRING)) {
            return Optional.empty();
        }
        ConvertingCodec<String, ?> codec = this.createStringConvertingCodec(cqlType, codecFactory, rootCodec);
        return Optional.ofNullable(codec);
    }

    @Nullable
    private ConvertingCodec<String, ?> createStringConvertingCodec(@NonNull DataType cqlType, @NonNull ConvertingCodecFactory codecFactory, boolean rootCodec) {
        ConversionContext context = codecFactory.getContext();
        ImmutableList nullStrings = rootCodec ? (List)context.getAttribute("NULL_STRINGS") : ImmutableList.of();
        int cqlTypeCode = cqlType.getProtocolCode();
        switch (cqlTypeCode) {
            case 1: 
            case 13: {
                TypeCodec typeCodec = codecFactory.getCodecRegistry().codecFor(cqlType);
                return new StringToStringCodec((TypeCodec<String>)typeCodec, (List<String>)nullStrings);
            }
            case 4: {
                return new StringToBooleanCodec((Map)context.getAttribute("BOOLEAN_INPUT_WORDS"), (Map)context.getAttribute("BOOLEAN_OUTPUT_WORDS"), (List<String>)nullStrings);
            }
            case 20: {
                return new StringToByteCodec((FastThreadLocal<NumberFormat>)((FastThreadLocal)context.getAttribute("NUMBER_FORMAT")), (OverflowStrategy)context.getAttribute("OVERFLOW_STRATEGY"), (RoundingMode)((Object)context.getAttribute("ROUNDING_MODE")), (TemporalFormat)context.getAttribute("TIMESTAMP_FORMAT"), (ZoneId)context.getAttribute("TIME_ZONE"), (TimeUnit)((Object)context.getAttribute("TIME_UNIT")), (ZonedDateTime)context.getAttribute("EPOCH"), (Map)context.getAttribute("BOOLEAN_INPUT_WORDS"), (List)context.getAttribute("BOOLEAN_NUMBERS"), (List<String>)nullStrings);
            }
            case 19: {
                return new StringToShortCodec((FastThreadLocal<NumberFormat>)((FastThreadLocal)context.getAttribute("NUMBER_FORMAT")), (OverflowStrategy)context.getAttribute("OVERFLOW_STRATEGY"), (RoundingMode)((Object)context.getAttribute("ROUNDING_MODE")), (TemporalFormat)context.getAttribute("TIMESTAMP_FORMAT"), (ZoneId)context.getAttribute("TIME_ZONE"), (TimeUnit)((Object)context.getAttribute("TIME_UNIT")), (ZonedDateTime)context.getAttribute("EPOCH"), (Map)context.getAttribute("BOOLEAN_INPUT_WORDS"), (List)context.getAttribute("BOOLEAN_NUMBERS"), (List<String>)nullStrings);
            }
            case 9: {
                return new StringToIntegerCodec((FastThreadLocal<NumberFormat>)((FastThreadLocal)context.getAttribute("NUMBER_FORMAT")), (OverflowStrategy)context.getAttribute("OVERFLOW_STRATEGY"), (RoundingMode)((Object)context.getAttribute("ROUNDING_MODE")), (TemporalFormat)context.getAttribute("TIMESTAMP_FORMAT"), (ZoneId)context.getAttribute("TIME_ZONE"), (TimeUnit)((Object)context.getAttribute("TIME_UNIT")), (ZonedDateTime)context.getAttribute("EPOCH"), (Map)context.getAttribute("BOOLEAN_INPUT_WORDS"), (List)context.getAttribute("BOOLEAN_NUMBERS"), (List<String>)nullStrings);
            }
            case 2: {
                return new StringToLongCodec(TypeCodecs.BIGINT, (FastThreadLocal<NumberFormat>)((FastThreadLocal)context.getAttribute("NUMBER_FORMAT")), (OverflowStrategy)context.getAttribute("OVERFLOW_STRATEGY"), (RoundingMode)((Object)context.getAttribute("ROUNDING_MODE")), (TemporalFormat)context.getAttribute("TIMESTAMP_FORMAT"), (ZoneId)context.getAttribute("TIME_ZONE"), (TimeUnit)((Object)context.getAttribute("TIME_UNIT")), (ZonedDateTime)context.getAttribute("EPOCH"), (Map<String, Boolean>)((Map)context.getAttribute("BOOLEAN_INPUT_WORDS")), (List)context.getAttribute("BOOLEAN_NUMBERS"), (List<String>)nullStrings);
            }
            case 5: {
                return new StringToLongCodec(TypeCodecs.COUNTER, (FastThreadLocal<NumberFormat>)((FastThreadLocal)context.getAttribute("NUMBER_FORMAT")), (OverflowStrategy)context.getAttribute("OVERFLOW_STRATEGY"), (RoundingMode)((Object)context.getAttribute("ROUNDING_MODE")), (TemporalFormat)context.getAttribute("TIMESTAMP_FORMAT"), (ZoneId)context.getAttribute("TIME_ZONE"), (TimeUnit)((Object)context.getAttribute("TIME_UNIT")), (ZonedDateTime)context.getAttribute("EPOCH"), (Map<String, Boolean>)((Map)context.getAttribute("BOOLEAN_INPUT_WORDS")), (List)context.getAttribute("BOOLEAN_NUMBERS"), (List<String>)nullStrings);
            }
            case 8: {
                return new StringToFloatCodec((FastThreadLocal<NumberFormat>)((FastThreadLocal)context.getAttribute("NUMBER_FORMAT")), (OverflowStrategy)context.getAttribute("OVERFLOW_STRATEGY"), (RoundingMode)((Object)context.getAttribute("ROUNDING_MODE")), (TemporalFormat)context.getAttribute("TIMESTAMP_FORMAT"), (ZoneId)context.getAttribute("TIME_ZONE"), (TimeUnit)((Object)context.getAttribute("TIME_UNIT")), (ZonedDateTime)context.getAttribute("EPOCH"), (Map)context.getAttribute("BOOLEAN_INPUT_WORDS"), (List)context.getAttribute("BOOLEAN_NUMBERS"), (List<String>)nullStrings);
            }
            case 7: {
                return new StringToDoubleCodec((FastThreadLocal<NumberFormat>)((FastThreadLocal)context.getAttribute("NUMBER_FORMAT")), (OverflowStrategy)context.getAttribute("OVERFLOW_STRATEGY"), (RoundingMode)((Object)context.getAttribute("ROUNDING_MODE")), (TemporalFormat)context.getAttribute("TIMESTAMP_FORMAT"), (ZoneId)context.getAttribute("TIME_ZONE"), (TimeUnit)((Object)context.getAttribute("TIME_UNIT")), (ZonedDateTime)context.getAttribute("EPOCH"), (Map)context.getAttribute("BOOLEAN_INPUT_WORDS"), (List)context.getAttribute("BOOLEAN_NUMBERS"), (List<String>)nullStrings);
            }
            case 14: {
                return new StringToBigIntegerCodec((FastThreadLocal<NumberFormat>)((FastThreadLocal)context.getAttribute("NUMBER_FORMAT")), (OverflowStrategy)context.getAttribute("OVERFLOW_STRATEGY"), (RoundingMode)((Object)context.getAttribute("ROUNDING_MODE")), (TemporalFormat)context.getAttribute("TIMESTAMP_FORMAT"), (ZoneId)context.getAttribute("TIME_ZONE"), (TimeUnit)((Object)context.getAttribute("TIME_UNIT")), (ZonedDateTime)context.getAttribute("EPOCH"), (Map)context.getAttribute("BOOLEAN_INPUT_WORDS"), (List)context.getAttribute("BOOLEAN_NUMBERS"), (List<String>)nullStrings);
            }
            case 6: {
                return new StringToBigDecimalCodec((FastThreadLocal<NumberFormat>)((FastThreadLocal)context.getAttribute("NUMBER_FORMAT")), (OverflowStrategy)context.getAttribute("OVERFLOW_STRATEGY"), (RoundingMode)((Object)context.getAttribute("ROUNDING_MODE")), (TemporalFormat)context.getAttribute("TIMESTAMP_FORMAT"), (ZoneId)context.getAttribute("TIME_ZONE"), (TimeUnit)((Object)context.getAttribute("TIME_UNIT")), (ZonedDateTime)context.getAttribute("EPOCH"), (Map)context.getAttribute("BOOLEAN_INPUT_WORDS"), (List)context.getAttribute("BOOLEAN_NUMBERS"), (List<String>)nullStrings);
            }
            case 17: {
                return new StringToLocalDateCodec((TemporalFormat)context.getAttribute("LOCAL_DATE_FORMAT"), (ZoneId)context.getAttribute("TIME_ZONE"), (List<String>)nullStrings);
            }
            case 18: {
                return new StringToLocalTimeCodec((TemporalFormat)context.getAttribute("LOCAL_TIME_FORMAT"), (ZoneId)context.getAttribute("TIME_ZONE"), (List<String>)nullStrings);
            }
            case 11: {
                return new StringToInstantCodec((TemporalFormat)context.getAttribute("TIMESTAMP_FORMAT"), (ZoneId)context.getAttribute("TIME_ZONE"), (ZonedDateTime)context.getAttribute("EPOCH"), (List<String>)nullStrings);
            }
            case 16: {
                return new StringToInetAddressCodec((List<String>)nullStrings);
            }
            case 12: {
                ConvertingCodec instantCodec = codecFactory.createConvertingCodec(DataTypes.TIMESTAMP, GenericType.STRING, false);
                return new StringToUUIDCodec((TypeCodec<UUID>)TypeCodecs.UUID, (ConvertingCodec<String, Instant>)instantCodec, (TimeUUIDGenerator)context.getAttribute("TIME_UUID_GENERATOR"), (List<String>)nullStrings);
            }
            case 15: {
                ConvertingCodec instantCodec = codecFactory.createConvertingCodec(DataTypes.TIMESTAMP, GenericType.STRING, false);
                return new StringToUUIDCodec((TypeCodec<UUID>)TypeCodecs.TIMEUUID, (ConvertingCodec<String, Instant>)instantCodec, (TimeUUIDGenerator)context.getAttribute("TIME_UUID_GENERATOR"), (List<String>)nullStrings);
            }
            case 3: {
                return new StringToBlobCodec((List<String>)nullStrings, (BinaryFormat)context.getAttribute("BINARY_FORMAT"));
            }
            case 21: {
                return new StringToDurationCodec((List<String>)nullStrings);
            }
            case 32: {
                ConvertingCodec jsonCodec = codecFactory.createConvertingCodec(cqlType, JsonCodecUtils.JSON_NODE_TYPE, false);
                return new StringToListCodec(jsonCodec, (ObjectMapper)context.getAttribute("OBJECT_MAPPER"), (List<String>)nullStrings);
            }
            case 34: {
                ConvertingCodec jsonCodec = codecFactory.createConvertingCodec(cqlType, JsonCodecUtils.JSON_NODE_TYPE, false);
                return new StringToSetCodec(jsonCodec, (ObjectMapper)context.getAttribute("OBJECT_MAPPER"), (List<String>)nullStrings);
            }
            case 33: {
                ConvertingCodec jsonCodec = codecFactory.createConvertingCodec(cqlType, JsonCodecUtils.JSON_NODE_TYPE, false);
                return new StringToMapCodec(jsonCodec, (ObjectMapper)context.getAttribute("OBJECT_MAPPER"), (List<String>)nullStrings);
            }
            case 49: {
                ConvertingCodec jsonCodec = codecFactory.createConvertingCodec(cqlType, JsonCodecUtils.JSON_NODE_TYPE, false);
                return new StringToTupleCodec((ConvertingCodec<JsonNode, TupleValue>)jsonCodec, (ObjectMapper)context.getAttribute("OBJECT_MAPPER"), (List<String>)nullStrings);
            }
            case 48: {
                ConvertingCodec jsonCodec = codecFactory.createConvertingCodec(cqlType, JsonCodecUtils.JSON_NODE_TYPE, false);
                return new StringToUDTCodec((ConvertingCodec<JsonNode, UdtValue>)jsonCodec, (ObjectMapper)context.getAttribute("OBJECT_MAPPER"), (List<String>)nullStrings);
            }
            case 0: {
                CustomType customType = (CustomType)cqlType;
                switch (customType.getClassName()) {
                    case "org.apache.cassandra.db.marshal.PointType": {
                        return new StringToPointCodec((GeoFormat)context.getAttribute("GEO_FORMAT"), (List<String>)nullStrings);
                    }
                    case "org.apache.cassandra.db.marshal.LineStringType": {
                        return new StringToLineStringCodec((GeoFormat)context.getAttribute("GEO_FORMAT"), (List<String>)nullStrings);
                    }
                    case "org.apache.cassandra.db.marshal.PolygonType": {
                        return new StringToPolygonCodec((GeoFormat)context.getAttribute("GEO_FORMAT"), (List<String>)nullStrings);
                    }
                    case "org.apache.cassandra.db.marshal.DateRangeType": {
                        return new StringToDateRangeCodec((List<String>)nullStrings);
                    }
                    case "org.apache.cassandra.db.marshal.VectorType": {
                        CqlVectorType cqlVectorType = (CqlVectorType)cqlType;
                        ConvertingCodec subtypeCodec = codecFactory.createConvertingCodec(cqlVectorType.getSubtype(), GenericType.STRING, false);
                        return new StringToVectorCodec(new CqlVectorCodec(cqlVectorType, (TypeCodec)subtypeCodec), (List<String>)nullStrings);
                    }
                }
            }
        }
        try {
            TypeCodec innerCodec = codecFactory.getCodecRegistry().codecFor(cqlType);
            LOGGER.warn(String.format("CQL type %s is not officially supported by this version of DSBulk; string literals will be parsed and formatted using registered codec %s", cqlType, innerCodec.getClass().getSimpleName()));
            return new StringToUnknownTypeCodec(innerCodec, (List<String>)nullStrings);
        }
        catch (CodecNotFoundException codecNotFoundException) {
            return null;
        }
    }
}

