/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.string;

import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.dsbulk.codecs.api.format.temporal.TemporalFormat;
import com.datastax.oss.dsbulk.codecs.api.util.OverflowStrategy;
import com.datastax.oss.dsbulk.codecs.text.string.StringToNumberCodec;
import io.netty.util.concurrent.FastThreadLocal;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class StringToBigIntegerCodec
extends StringToNumberCodec<BigInteger> {
    public StringToBigIntegerCodec(FastThreadLocal<NumberFormat> numberFormat, OverflowStrategy overflowStrategy, RoundingMode roundingMode, TemporalFormat temporalFormat, ZoneId timeZone, TimeUnit timeUnit, ZonedDateTime epoch, Map<String, Boolean> booleanStrings, List<BigDecimal> booleanNumbers, List<String> nullStrings) {
        super(TypeCodecs.VARINT, numberFormat, overflowStrategy, roundingMode, temporalFormat, timeZone, timeUnit, epoch, booleanStrings, booleanNumbers.stream().map(BigDecimal::toBigInteger).collect(Collectors.toList()), nullStrings);
    }

    public BigInteger externalToInternal(String s) {
        Number number = this.parseNumber(s);
        if (number == null) {
            return null;
        }
        return this.narrowNumber(number, BigInteger.class);
    }
}

