/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.string;

import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.dsbulk.codecs.api.format.binary.BinaryFormat;
import com.datastax.oss.dsbulk.codecs.api.util.CodecUtils;
import com.datastax.oss.dsbulk.codecs.text.string.StringConvertingCodec;
import java.nio.ByteBuffer;
import java.util.List;

public class StringToBlobCodec
extends StringConvertingCodec<ByteBuffer> {
    private final BinaryFormat binaryFormat;

    public StringToBlobCodec(List<String> nullStrings, BinaryFormat binaryFormat) {
        super(TypeCodecs.BLOB, nullStrings);
        this.binaryFormat = binaryFormat;
    }

    public ByteBuffer externalToInternal(String s) {
        if (this.isNull(s)) {
            return null;
        }
        return CodecUtils.parseByteBuffer((String)s);
    }

    public String internalToExternal(ByteBuffer value) {
        if (value == null) {
            return this.nullString();
        }
        return this.binaryFormat.format(value);
    }
}

