/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.string;

import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.dsbulk.codecs.text.string.StringConvertingCodec;
import java.util.List;
import java.util.Map;

public class StringToBooleanCodec
extends StringConvertingCodec<Boolean> {
    private final Map<String, Boolean> inputs;
    private final Map<Boolean, String> outputs;

    public StringToBooleanCodec(Map<String, Boolean> inputs, Map<Boolean, String> outputs, List<String> nullStrings) {
        super(TypeCodecs.BOOLEAN, nullStrings);
        this.inputs = inputs;
        this.outputs = outputs;
    }

    public Boolean externalToInternal(String s) {
        if (this.isNullOrEmpty(s)) {
            return null;
        }
        Boolean b = this.inputs.get(s.toLowerCase());
        if (b == null) {
            throw new IllegalArgumentException("Invalid boolean value: " + s);
        }
        return b;
    }

    public String internalToExternal(Boolean value) {
        if (value == null) {
            return this.nullString();
        }
        String s = this.outputs.get(value);
        if (s == null) {
            return Boolean.toString(value);
        }
        return s;
    }
}

