/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.string;

import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import com.datastax.oss.dsbulk.codecs.text.string.StringConvertingCodec;
import com.datastax.oss.dsbulk.codecs.text.utils.StringUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public abstract class StringToCollectionCodec<E, C extends Collection<E>>
extends StringConvertingCodec<C> {
    private final ConvertingCodec<JsonNode, C> jsonCodec;
    private final ObjectMapper objectMapper;

    StringToCollectionCodec(ConvertingCodec<JsonNode, C> jsonCodec, ObjectMapper objectMapper, List<String> nullStrings) {
        super(jsonCodec.getInternalCodec(), nullStrings);
        this.jsonCodec = jsonCodec;
        this.objectMapper = objectMapper;
    }

    public C externalToInternal(String s) {
        if (this.isNullOrEmpty(s)) {
            return null;
        }
        try {
            JsonNode node = this.objectMapper.readTree(StringUtils.ensureBrackets(s));
            return (C)((Collection)this.jsonCodec.externalToInternal((Object)node));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Could not parse '%s' as Json", s), e);
        }
    }

    public String internalToExternal(C collection) {
        if (collection == null) {
            return this.nullString();
        }
        try {
            JsonNode node = (JsonNode)this.jsonCodec.internalToExternal(collection);
            return this.objectMapper.writeValueAsString((Object)node);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(String.format("Could not format '%s' to Json", collection), e);
        }
    }
}

