/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.string;

import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.dsbulk.codecs.text.string.StringConvertingCodec;
import java.net.InetAddress;
import java.util.List;

public class StringToInetAddressCodec
extends StringConvertingCodec<InetAddress> {
    public StringToInetAddressCodec(List<String> nullStrings) {
        super(TypeCodecs.INET, nullStrings);
    }

    public InetAddress externalToInternal(String s) {
        if (this.isNullOrEmpty(s)) {
            return null;
        }
        if (s.isEmpty()) {
            throw new IllegalArgumentException("Cannot create inet address from empty string");
        }
        try {
            return InetAddress.getByName(s);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot parse inet address: " + s);
        }
    }

    public String internalToExternal(InetAddress value) {
        if (value == null) {
            return this.nullString();
        }
        return value.getHostAddress();
    }
}

