/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.string;

import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.dsbulk.codecs.api.format.temporal.TemporalFormat;
import com.datastax.oss.dsbulk.codecs.api.util.CodecUtils;
import com.datastax.oss.dsbulk.codecs.text.string.StringToTemporalCodec;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAccessor;
import java.util.List;

public class StringToLocalDateCodec
extends StringToTemporalCodec<LocalDate> {
    private final ZoneId timeZone;

    public StringToLocalDateCodec(TemporalFormat parser, ZoneId timeZone, List<String> nullStrings) {
        super(TypeCodecs.DATE, parser, nullStrings);
        this.timeZone = timeZone;
    }

    public LocalDate externalToInternal(String s) {
        TemporalAccessor temporal = this.parseTemporalAccessor(s);
        if (temporal == null) {
            return null;
        }
        return CodecUtils.toLocalDate((TemporalAccessor)temporal, (ZoneId)this.timeZone);
    }
}

