/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.string;

import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import com.datastax.oss.dsbulk.codecs.text.string.StringConvertingCodec;
import com.datastax.oss.dsbulk.codecs.text.utils.StringUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class StringToMapCodec<K, V>
extends StringConvertingCodec<Map<K, V>> {
    private final ConvertingCodec<JsonNode, Map<K, V>> jsonCodec;
    private final ObjectMapper objectMapper;

    public StringToMapCodec(ConvertingCodec<JsonNode, Map<K, V>> jsonCodec, ObjectMapper objectMapper, List<String> nullStrings) {
        super(jsonCodec.getInternalCodec(), nullStrings);
        this.jsonCodec = jsonCodec;
        this.objectMapper = objectMapper;
    }

    public Map<K, V> externalToInternal(String s) {
        if (this.isNullOrEmpty(s)) {
            return null;
        }
        try {
            JsonNode node = this.objectMapper.readTree(StringUtils.ensureBraces(s));
            return (Map)this.jsonCodec.externalToInternal((Object)node);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Could not parse '%s' as Json", s), e);
        }
    }

    public String internalToExternal(Map<K, V> map) {
        if (map == null) {
            return this.nullString();
        }
        try {
            JsonNode node = (JsonNode)this.jsonCodec.internalToExternal(map);
            return this.objectMapper.writeValueAsString((Object)node);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(String.format("Could not format '%s' to Json", map), e);
        }
    }
}

