/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.string;

import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.dsbulk.codecs.api.format.temporal.TemporalFormat;
import com.datastax.oss.dsbulk.codecs.text.string.StringConvertingCodec;
import java.time.temporal.TemporalAccessor;
import java.util.List;

public abstract class StringToTemporalCodec<T extends TemporalAccessor>
extends StringConvertingCodec<T> {
    final TemporalFormat temporalFormat;

    StringToTemporalCodec(TypeCodec<T> targetCodec, TemporalFormat temporalFormat, List<String> nullStrings) {
        super(targetCodec, nullStrings);
        this.temporalFormat = temporalFormat;
    }

    public String internalToExternal(T value) {
        if (value == null) {
            return this.nullString();
        }
        return this.temporalFormat.format(value);
    }

    TemporalAccessor parseTemporalAccessor(String s) {
        if (this.isNullOrEmpty(s)) {
            return null;
        }
        return this.temporalFormat.parse(s);
    }
}

