/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.string;

import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import com.datastax.oss.dsbulk.codecs.text.string.StringConvertingCodec;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;

public class StringToTupleCodec
extends StringConvertingCodec<TupleValue> {
    private final ConvertingCodec<JsonNode, TupleValue> jsonCodec;
    private final ObjectMapper objectMapper;

    public StringToTupleCodec(ConvertingCodec<JsonNode, TupleValue> jsonCodec, ObjectMapper objectMapper, List<String> nullStrings) {
        super(jsonCodec.getInternalCodec(), nullStrings);
        this.jsonCodec = jsonCodec;
        this.objectMapper = objectMapper;
    }

    public TupleValue externalToInternal(String s) {
        if (this.isNullOrEmpty(s)) {
            return null;
        }
        try {
            JsonNode node = this.objectMapper.readTree(s);
            return (TupleValue)this.jsonCodec.externalToInternal((Object)node);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Could not parse '%s' as Json", s), e);
        }
    }

    public String internalToExternal(TupleValue tuple) {
        if (tuple == null) {
            return this.nullString();
        }
        try {
            JsonNode node = (JsonNode)this.jsonCodec.internalToExternal((Object)tuple);
            return this.objectMapper.writeValueAsString((Object)node);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(String.format("Could not format '%s' to Json", tuple), e);
        }
    }
}

