/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.string;

import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import com.datastax.oss.dsbulk.codecs.api.util.CodecUtils;
import com.datastax.oss.dsbulk.codecs.api.util.TimeUUIDGenerator;
import com.datastax.oss.dsbulk.codecs.text.string.StringConvertingCodec;
import java.time.Instant;
import java.util.List;
import java.util.UUID;

public class StringToUUIDCodec
extends StringConvertingCodec<UUID> {
    private final ConvertingCodec<String, Instant> instantCodec;
    private final TimeUUIDGenerator generator;

    public StringToUUIDCodec(TypeCodec<UUID> targetCodec, ConvertingCodec<String, Instant> instantCodec, TimeUUIDGenerator generator, List<String> nullStrings) {
        super(targetCodec, nullStrings);
        this.instantCodec = instantCodec;
        this.generator = generator;
    }

    public UUID externalToInternal(String s) {
        if (this.isNullOrEmpty(s)) {
            return null;
        }
        return CodecUtils.parseUUID((String)s, this.instantCodec, (TimeUUIDGenerator)this.generator);
    }

    public String internalToExternal(UUID value) {
        if (value == null) {
            return this.nullString();
        }
        return value.toString();
    }
}

