/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.dao;

import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.mapper.annotations.Delete;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoImplementationSharedCode;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoMethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoReturnType;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoReturnTypeKind;
import com.datastax.oss.driver.internal.mapper.processor.dao.DefaultDaoReturnTypeKind;
import com.datastax.oss.driver.internal.mapper.processor.dao.EntityUtils;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityDefinition;
import com.datastax.oss.driver.internal.mapper.processor.entity.PropertyDefinition;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.GeneratedCodePatterns;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class DaoDeleteMethodGenerator
extends DaoMethodGenerator {
    public DaoDeleteMethodGenerator(ExecutableElement methodElement, Map<Name, TypeElement> typeParameters, DaoImplementationSharedCode enclosingClass, ProcessorContext context) {
        super(methodElement, typeParameters, enclosingClass, context);
    }

    protected Set<DaoReturnTypeKind> getSupportedReturnTypes() {
        return ImmutableSet.of((Object)DefaultDaoReturnTypeKind.VOID, (Object)DefaultDaoReturnTypeKind.FUTURE_OF_VOID, (Object)DefaultDaoReturnTypeKind.BOOLEAN, (Object)DefaultDaoReturnTypeKind.FUTURE_OF_BOOLEAN, (Object)DefaultDaoReturnTypeKind.RESULT_SET, (Object)DefaultDaoReturnTypeKind.FUTURE_OF_ASYNC_RESULT_SET, (Object[])new DaoReturnTypeKind[0]);
    }

    @Override
    public Optional<MethodSpec> generate() {
        int nextParameterIndex;
        EntityDefinition entityDefinition;
        boolean hasEntityParameter;
        Delete annotation = this.methodElement.getAnnotation(Delete.class);
        assert (annotation != null);
        if (annotation.ifExists() && !annotation.customIfClause().isEmpty()) {
            this.context.getMessager().error(this.methodElement, "Invalid annotation parameters: %s cannot have both ifExists and customIfClause", Delete.class.getSimpleName());
            return Optional.empty();
        }
        List<? extends VariableElement> parameters = this.methodElement.getParameters();
        VariableElement boundStatementFunction = this.findBoundStatementFunction(this.methodElement);
        if (boundStatementFunction != null) {
            parameters = parameters.subList(0, parameters.size() - 1);
        }
        if (parameters.isEmpty()) {
            this.context.getMessager().error(this.methodElement, "Wrong number of parameters: %s methods with no custom clause must take either an entity instance, or the partition key components", Delete.class.getSimpleName());
            return Optional.empty();
        }
        VariableElement firstParameter = parameters.get(0);
        TypeElement entityElement = EntityUtils.asEntityElement(firstParameter, (Map<Name, TypeElement>)this.typeParameters);
        boolean bl = hasEntityParameter = entityElement != null;
        if (hasEntityParameter) {
            entityDefinition = this.context.getEntityFactory().getDefinition(entityElement);
        } else {
            entityElement = this.getEntityFromAnnotation();
            if (entityElement == null) {
                this.context.getMessager().error(this.methodElement, "Missing entity class: %s methods that do not operate on an entity instance must have an 'entityClass' argument", Delete.class.getSimpleName());
                return Optional.empty();
            }
            entityDefinition = this.context.getEntityFactory().getDefinition(entityElement);
            List primaryKeyTypes = entityDefinition.getPrimaryKey().stream().map(d -> d.getType().asTypeName()).collect(Collectors.toList());
            List parameterTypes = parameters.stream().map(p -> TypeName.get((TypeMirror)p.asType())).collect(Collectors.toList());
            if (parameterTypes.size() < primaryKeyTypes.size() || !primaryKeyTypes.equals(parameterTypes.subList(0, primaryKeyTypes.size()))) {
                this.context.getMessager().error(this.methodElement, "Invalid parameter list: %s methods that do not operate on an entity instance must take the partition key components in the exact order (expected PK of %s: %s)", Delete.class.getSimpleName(), entityElement.getSimpleName(), primaryKeyTypes);
                return Optional.empty();
            }
        }
        DaoReturnType returnType = this.parseAndValidateReturnType(this.getSupportedReturnTypes(), Delete.class.getSimpleName());
        if (returnType == null) {
            return Optional.empty();
        }
        String helperFieldName = this.enclosingClass.addEntityHelperField(ClassName.get((TypeElement)entityElement));
        String statementName = this.enclosingClass.addPreparedStatement(this.methodElement, (methodBuilder, requestName) -> this.generatePrepareRequest((MethodSpec.Builder)methodBuilder, (String)requestName, helperFieldName));
        CodeBlock.Builder methodBodyBuilder = CodeBlock.builder();
        methodBodyBuilder.addStatement("$T boundStatementBuilder = $L.boundStatementBuilder()", new Object[]{BoundStatementBuilder.class, statementName});
        this.populateBuilderWithStatementAttributes(methodBodyBuilder, this.methodElement);
        this.populateBuilderWithFunction(methodBodyBuilder, boundStatementFunction);
        if (hasEntityParameter) {
            this.warnIfCqlNamePresent(Collections.singletonList(firstParameter));
            for (PropertyDefinition property : entityDefinition.getPrimaryKey()) {
                GeneratedCodePatterns.setValue(property.getCqlName(), property.getType(), CodeBlock.of((String)"$L.$L()", (Object[])new Object[]{firstParameter.getSimpleName(), property.getGetterName()}), "boundStatementBuilder", methodBodyBuilder, this.enclosingClass);
            }
            nextParameterIndex = 1;
        } else {
            List<CodeBlock> primaryKeyNames = entityDefinition.getPrimaryKey().stream().map(PropertyDefinition::getCqlName).collect(Collectors.toList());
            List<? extends VariableElement> bindMarkers = parameters.subList(0, primaryKeyNames.size());
            this.warnIfCqlNamePresent(bindMarkers);
            GeneratedCodePatterns.bindParameters(bindMarkers, primaryKeyNames, methodBodyBuilder, this.enclosingClass, this.context, false);
            nextParameterIndex = primaryKeyNames.size();
        }
        if (nextParameterIndex < parameters.size()) {
            List<? extends VariableElement> bindMarkers;
            if (annotation.customIfClause().isEmpty()) {
                this.context.getMessager().error(this.methodElement, "Wrong number of parameters: %s methods can only have additional parameters if they specify a custom IF clause", Delete.class.getSimpleName());
            }
            if (this.validateCqlNamesPresent(bindMarkers = parameters.subList(nextParameterIndex, parameters.size()))) {
                GeneratedCodePatterns.bindParameters(bindMarkers, methodBodyBuilder, this.enclosingClass, this.context, false);
            } else {
                return Optional.empty();
            }
        }
        methodBodyBuilder.add("\n", new Object[0]).addStatement("$T boundStatement = boundStatementBuilder.build()", new Object[]{BoundStatement.class});
        returnType.getKind().addExecuteStatement(methodBodyBuilder, helperFieldName);
        CodeBlock methodBody = returnType.getKind().wrapWithErrorHandling(methodBodyBuilder.build());
        return Optional.of(GeneratedCodePatterns.override(this.methodElement, this.typeParameters).addCode(methodBody).build());
    }

    private TypeElement getEntityFromAnnotation() {
        AnnotationMirror annotationMirror = null;
        for (AnnotationMirror annotationMirror2 : this.methodElement.getAnnotationMirrors()) {
            if (!this.context.getClassUtils().isSame(annotationMirror2.getAnnotationType(), Delete.class)) continue;
            annotationMirror = annotationMirror2;
            break;
        }
        assert (annotationMirror != null);
        for (Map.Entry entry : annotationMirror.getElementValues().entrySet()) {
            if (!((ExecutableElement)entry.getKey()).getSimpleName().contentEquals("entityClass")) continue;
            List values = (List)((AnnotationValue)entry.getValue()).getValue();
            if (values.isEmpty()) {
                return null;
            }
            TypeMirror mirror = (TypeMirror)((AnnotationValue)values.get(0)).getValue();
            TypeElement element = EntityUtils.asEntityElement(mirror, (Map<Name, TypeElement>)this.typeParameters);
            if (values.size() > 1) {
                this.context.getMessager().warn(this.methodElement, "Too many entity classes: %s must have at most one 'entityClass' argument (will use the first one: %s)", Delete.class.getSimpleName(), element.getSimpleName());
            }
            return element;
        }
        return null;
    }

    private void generatePrepareRequest(MethodSpec.Builder methodBuilder, String requestName, String helperFieldName) {
        boolean ifExists = this.methodElement.getAnnotation(Delete.class).ifExists();
        String customIfClause = this.methodElement.getAnnotation(Delete.class).customIfClause();
        if (ifExists) {
            methodBuilder.addStatement("$T $L = $L.deleteByPrimaryKey().ifExists().build()", new Object[]{SimpleStatement.class, requestName, helperFieldName});
        } else if (!customIfClause.isEmpty()) {
            methodBuilder.addStatement("$T $L = $L.deleteByPrimaryKey().ifRaw($S).build()", new Object[]{SimpleStatement.class, requestName, helperFieldName, customIfClause});
        } else {
            methodBuilder.addStatement("$T $L = $L.deleteByPrimaryKey().build()", new Object[]{SimpleStatement.class, requestName, helperFieldName});
        }
    }
}

