/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.dao;

import com.datastax.oss.driver.api.core.MappedAsyncPagingIterable;
import com.datastax.oss.driver.api.core.PagingIterable;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.data.GettableByName;
import com.datastax.oss.driver.api.mapper.annotations.Entity;
import com.datastax.oss.driver.api.mapper.annotations.GetEntity;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoImplementationSharedCode;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoMethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.dao.EntityUtils;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.GeneratedCodePatterns;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class DaoGetEntityMethodGenerator
extends DaoMethodGenerator {
    public DaoGetEntityMethodGenerator(ExecutableElement methodElement, Map<Name, TypeElement> typeParameters, DaoImplementationSharedCode enclosingClass, ProcessorContext context) {
        super(methodElement, typeParameters, enclosingClass, context);
    }

    @Override
    public Optional<MethodSpec> generate() {
        if (this.methodElement.getParameters().size() != 1) {
            this.context.getMessager().error(this.methodElement, "Wrong number of parameters: %s methods must have exactly one", GetEntity.class.getSimpleName());
            return Optional.empty();
        }
        VariableElement parameterElement = this.methodElement.getParameters().get(0);
        String parameterName = parameterElement.getSimpleName().toString();
        TypeMirror parameterType = parameterElement.asType();
        boolean parameterIsGettable = this.context.getClassUtils().implementsGettableByName(parameterType);
        boolean parameterIsResultSet = this.context.getClassUtils().isSame(parameterType, ResultSet.class);
        boolean parameterIsAsyncResultSet = this.context.getClassUtils().isSame(parameterType, AsyncResultSet.class);
        if (!(parameterIsGettable || parameterIsResultSet || parameterIsAsyncResultSet)) {
            this.context.getMessager().error(parameterElement, "Invalid parameter type: %s methods must take a %s, %s or %s", GetEntity.class.getSimpleName(), GettableByName.class.getSimpleName(), ResultSet.class.getSimpleName(), AsyncResultSet.class.getSimpleName());
            return Optional.empty();
        }
        Transformation transformation = null;
        TypeMirror returnType = this.methodElement.getReturnType();
        TypeElement entityElement = EntityUtils.asEntityElement(returnType, (Map<Name, TypeElement>)this.typeParameters);
        if (entityElement != null) {
            transformation = parameterIsGettable ? Transformation.NONE : Transformation.ONE;
        } else if (returnType.getKind() == TypeKind.DECLARED) {
            Element element = ((DeclaredType)returnType).asElement();
            if (this.context.getClassUtils().isSame(element, PagingIterable.class)) {
                if (!parameterIsResultSet) {
                    this.context.getMessager().error(this.methodElement, "Invalid return type: %s methods must return %s if the argument is %s", GetEntity.class.getSimpleName(), PagingIterable.class.getSimpleName(), ResultSet.class.getSimpleName());
                    return Optional.empty();
                }
                entityElement = EntityUtils.typeArgumentAsEntityElement(returnType, this.typeParameters);
                transformation = Transformation.MAP;
            } else if (this.context.getClassUtils().isSame(element, MappedAsyncPagingIterable.class)) {
                if (!parameterIsAsyncResultSet) {
                    this.context.getMessager().error(this.methodElement, "Invalid return type: %s methods must return %s if the argument is %s", GetEntity.class.getSimpleName(), MappedAsyncPagingIterable.class.getSimpleName(), AsyncResultSet.class.getSimpleName());
                    return Optional.empty();
                }
                entityElement = EntityUtils.typeArgumentAsEntityElement(returnType, this.typeParameters);
                transformation = Transformation.MAP;
            }
        }
        if (entityElement == null) {
            this.context.getMessager().error(this.methodElement, "Invalid return type: %s methods must return a %s-annotated class, or a %s or %s thereof", GetEntity.class.getSimpleName(), Entity.class.getSimpleName(), PagingIterable.class.getSimpleName(), MappedAsyncPagingIterable.class.getSimpleName());
            return Optional.empty();
        }
        String helperFieldName = this.enclosingClass.addEntityHelperField(ClassName.get((TypeElement)entityElement));
        MethodSpec.Builder overridingMethodBuilder = GeneratedCodePatterns.override(this.methodElement, this.typeParameters);
        switch (transformation) {
            case NONE: {
                overridingMethodBuilder.addStatement("return $L.get($L)", new Object[]{helperFieldName, parameterName});
                break;
            }
            case ONE: {
                overridingMethodBuilder.addStatement("$T row = $L.one()", new Object[]{Row.class, parameterName}).addStatement("return (row == null) ? null : $L.get(row)", new Object[]{helperFieldName});
                break;
            }
            case MAP: {
                overridingMethodBuilder.addStatement("return $L.map($L::get)", new Object[]{parameterName, helperFieldName});
            }
        }
        return Optional.of(overridingMethodBuilder.build());
    }

    private static enum Transformation {
        NONE,
        ONE,
        MAP;

    }
}

