/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.dao;

import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.mapper.annotations.Insert;
import com.datastax.oss.driver.api.mapper.entity.saving.NullSavingStrategy;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoImplementationSharedCode;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoMethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoReturnType;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoReturnTypeKind;
import com.datastax.oss.driver.internal.mapper.processor.dao.DefaultDaoReturnTypeKind;
import com.datastax.oss.driver.internal.mapper.processor.dao.EntityUtils;
import com.datastax.oss.driver.internal.mapper.processor.dao.NullSavingStrategyValidation;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.GeneratedCodePatterns;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public class DaoInsertMethodGenerator
extends DaoMethodGenerator {
    private final NullSavingStrategyValidation nullSavingStrategyValidation;

    public DaoInsertMethodGenerator(ExecutableElement methodElement, Map<Name, TypeElement> typeParameters, DaoImplementationSharedCode enclosingClass, ProcessorContext context) {
        super(methodElement, typeParameters, enclosingClass, context);
        this.nullSavingStrategyValidation = new NullSavingStrategyValidation(context);
    }

    protected Set<DaoReturnTypeKind> getSupportedReturnTypes() {
        return ImmutableSet.of((Object)DefaultDaoReturnTypeKind.VOID, (Object)DefaultDaoReturnTypeKind.FUTURE_OF_VOID, (Object)DefaultDaoReturnTypeKind.ENTITY, (Object)DefaultDaoReturnTypeKind.FUTURE_OF_ENTITY, (Object)DefaultDaoReturnTypeKind.OPTIONAL_ENTITY, (Object)DefaultDaoReturnTypeKind.FUTURE_OF_OPTIONAL_ENTITY, (Object[])new DaoReturnTypeKind[]{DefaultDaoReturnTypeKind.BOOLEAN, DefaultDaoReturnTypeKind.FUTURE_OF_BOOLEAN, DefaultDaoReturnTypeKind.RESULT_SET, DefaultDaoReturnTypeKind.FUTURE_OF_ASYNC_RESULT_SET});
    }

    @Override
    public Optional<MethodSpec> generate() {
        TypeElement entityElement;
        List<? extends VariableElement> parameters = this.methodElement.getParameters();
        VariableElement boundStatementFunction = this.findBoundStatementFunction(this.methodElement);
        if (boundStatementFunction != null) {
            parameters = parameters.subList(0, parameters.size() - 1);
        }
        TypeElement typeElement = entityElement = parameters.isEmpty() ? null : EntityUtils.asEntityElement(parameters.get(0), (Map<Name, TypeElement>)this.typeParameters);
        if (entityElement == null) {
            this.context.getMessager().error(this.methodElement, "%s methods must take the entity to insert as the first parameter", Insert.class.getSimpleName());
            return Optional.empty();
        }
        DaoReturnType returnType = this.parseAndValidateReturnType(this.getSupportedReturnTypes(), Insert.class.getSimpleName());
        if (returnType == null) {
            return Optional.empty();
        }
        if (returnType.getEntityElement() != null && !returnType.getEntityElement().equals(entityElement)) {
            this.context.getMessager().error(this.methodElement, "Invalid return type: %s methods must return the same entity as their argument ", Insert.class.getSimpleName());
            return Optional.empty();
        }
        String helperFieldName = this.enclosingClass.addEntityHelperField(ClassName.get((TypeElement)entityElement));
        String statementName = this.enclosingClass.addPreparedStatement(this.methodElement, (methodBuilder, requestName) -> this.generatePrepareRequest((MethodSpec.Builder)methodBuilder, (String)requestName, helperFieldName));
        CodeBlock.Builder methodBodyBuilder = CodeBlock.builder();
        methodBodyBuilder.addStatement("$T boundStatementBuilder = $L.boundStatementBuilder()", new Object[]{BoundStatementBuilder.class, statementName});
        this.populateBuilderWithStatementAttributes(methodBodyBuilder, this.methodElement);
        this.populateBuilderWithFunction(methodBodyBuilder, boundStatementFunction);
        this.warnIfCqlNamePresent(parameters.subList(0, 1));
        String entityParameterName = parameters.get(0).getSimpleName().toString();
        NullSavingStrategy nullSavingStrategy = this.nullSavingStrategyValidation.getNullSavingStrategy(Insert.class, Insert::nullSavingStrategy, this.methodElement, this.enclosingClass);
        methodBodyBuilder.addStatement("$1L.set($2L, boundStatementBuilder, $3T.$4L)", new Object[]{helperFieldName, entityParameterName, NullSavingStrategy.class, nullSavingStrategy});
        if (parameters.size() > 1) {
            List<? extends VariableElement> bindMarkers = parameters.subList(1, parameters.size());
            if (this.validateCqlNamesPresent(bindMarkers)) {
                GeneratedCodePatterns.bindParameters(bindMarkers, methodBodyBuilder, this.enclosingClass, this.context, false);
            } else {
                return Optional.empty();
            }
        }
        methodBodyBuilder.add("\n", new Object[0]).addStatement("$T boundStatement = boundStatementBuilder.build()", new Object[]{BoundStatement.class});
        returnType.getKind().addExecuteStatement(methodBodyBuilder, helperFieldName);
        CodeBlock methodBody = returnType.getKind().wrapWithErrorHandling(methodBodyBuilder.build());
        return Optional.of(GeneratedCodePatterns.override(this.methodElement, this.typeParameters).addCode(methodBody).build());
    }

    private void generatePrepareRequest(MethodSpec.Builder methodBuilder, String requestName, String helperFieldName) {
        methodBuilder.addCode("$[$T $L = $L.insert()", new Object[]{SimpleStatement.class, requestName, helperFieldName});
        Insert annotation = this.methodElement.getAnnotation(Insert.class);
        if (annotation.ifNotExists()) {
            methodBuilder.addCode(".ifNotExists()", new Object[0]);
        }
        this.maybeAddTtl(annotation.ttl(), methodBuilder);
        this.maybeAddTimestamp(annotation.timestamp(), methodBuilder);
        methodBuilder.addCode(".build()$];\n", new Object[0]);
    }
}

