/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.dao;

import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.mapper.annotations.Select;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoImplementationSharedCode;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoMethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoReturnType;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoReturnTypeKind;
import com.datastax.oss.driver.internal.mapper.processor.dao.DefaultDaoReturnTypeKind;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityDefinition;
import com.datastax.oss.driver.internal.mapper.processor.entity.PropertyDefinition;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.GeneratedCodePatterns;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class DaoSelectMethodGenerator
extends DaoMethodGenerator {
    public DaoSelectMethodGenerator(ExecutableElement methodElement, Map<Name, TypeElement> typeParameters, DaoImplementationSharedCode enclosingClass, ProcessorContext context) {
        super(methodElement, typeParameters, enclosingClass, context);
    }

    protected Set<DaoReturnTypeKind> getSupportedReturnTypes() {
        return ImmutableSet.of((Object)DefaultDaoReturnTypeKind.ENTITY, (Object)DefaultDaoReturnTypeKind.OPTIONAL_ENTITY, (Object)DefaultDaoReturnTypeKind.FUTURE_OF_ENTITY, (Object)DefaultDaoReturnTypeKind.FUTURE_OF_OPTIONAL_ENTITY, (Object)DefaultDaoReturnTypeKind.PAGING_ITERABLE, (Object)DefaultDaoReturnTypeKind.FUTURE_OF_ASYNC_PAGING_ITERABLE, (Object[])new DaoReturnTypeKind[0]);
    }

    @Override
    public Optional<MethodSpec> generate() {
        List parameterTypes;
        List primaryKeyTypes;
        DaoReturnType returnType = this.parseAndValidateReturnType(this.getSupportedReturnTypes(), Select.class.getSimpleName());
        if (returnType == null) {
            return Optional.empty();
        }
        TypeElement entityElement = returnType.getEntityElement();
        EntityDefinition entityDefinition = this.context.getEntityFactory().getDefinition(entityElement);
        List<? extends VariableElement> parameters = this.methodElement.getParameters();
        VariableElement boundStatementFunction = this.findBoundStatementFunction(this.methodElement);
        if (boundStatementFunction != null) {
            parameters = parameters.subList(0, parameters.size() - 1);
        }
        Select selectAnnotation = this.methodElement.getAnnotation(Select.class);
        assert (selectAnnotation != null);
        String customClause = selectAnnotation.customWhereClause();
        if (customClause.isEmpty() && !(primaryKeyTypes = entityDefinition.getPrimaryKey().stream().map(d -> d.getType().asTypeName()).collect(Collectors.toList())).equals(parameterTypes = parameters.stream().map(p -> TypeName.get((TypeMirror)p.asType())).collect(Collectors.toList()))) {
            this.context.getMessager().error(this.methodElement, "Invalid parameter list: %s methods that don't use a custom clause must take the partition key components in the exact order (expected PK of %s: %s)", Select.class.getSimpleName(), entityElement.getSimpleName(), primaryKeyTypes);
            return Optional.empty();
        }
        String helperFieldName = this.enclosingClass.addEntityHelperField(ClassName.get((TypeElement)entityElement));
        String statementName = this.enclosingClass.addPreparedStatement(this.methodElement, (methodBuilder, requestName) -> this.generateSelectRequest((MethodSpec.Builder)methodBuilder, (String)requestName, helperFieldName));
        CodeBlock.Builder methodBodyBuilder = CodeBlock.builder();
        methodBodyBuilder.addStatement("$T boundStatementBuilder = $L.boundStatementBuilder()", new Object[]{BoundStatementBuilder.class, statementName});
        this.populateBuilderWithStatementAttributes(methodBodyBuilder, this.methodElement);
        this.populateBuilderWithFunction(methodBodyBuilder, boundStatementFunction);
        if (parameters.size() > 0) {
            if (customClause.isEmpty()) {
                List<CodeBlock> primaryKeyNames = entityDefinition.getPrimaryKey().stream().map(PropertyDefinition::getCqlName).collect(Collectors.toList());
                this.warnIfCqlNamePresent(parameters);
                GeneratedCodePatterns.bindParameters(parameters, primaryKeyNames, methodBodyBuilder, this.enclosingClass, this.context, false);
            } else if (this.validateCqlNamesPresent(parameters)) {
                GeneratedCodePatterns.bindParameters(parameters, methodBodyBuilder, this.enclosingClass, this.context, false);
            } else {
                return Optional.empty();
            }
        }
        methodBodyBuilder.add("\n", new Object[0]).addStatement("$T boundStatement = boundStatementBuilder.build()", new Object[]{BoundStatement.class});
        returnType.getKind().addExecuteStatement(methodBodyBuilder, helperFieldName);
        CodeBlock methodBody = returnType.getKind().wrapWithErrorHandling(methodBodyBuilder.build());
        return Optional.of(GeneratedCodePatterns.override(this.methodElement, this.typeParameters).addCode(methodBody).build());
    }

    private void generateSelectRequest(MethodSpec.Builder methodBuilder, String requestName, String helperFieldName) {
        String customWhereClause = this.methodElement.getAnnotation(Select.class).customWhereClause();
        if (customWhereClause.isEmpty()) {
            methodBuilder.addStatement("$T $L = $L.selectByPrimaryKey().build()", new Object[]{SimpleStatement.class, requestName, helperFieldName});
        } else {
            methodBuilder.addStatement("$T $L = $L.selectStart().whereRaw($S).build()", new Object[]{SimpleStatement.class, requestName, helperFieldName, customWhereClause});
        }
    }
}

