/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.dao;

import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoReturnTypeKind;
import com.squareup.javapoet.CodeBlock;

public enum DefaultDaoReturnTypeKind implements DaoReturnTypeKind
{
    VOID(false){

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("execute(boundStatement)", new Object[0]);
        }
    }
    ,
    BOOLEAN(false){

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeAndMapWasAppliedToBoolean(boundStatement)", new Object[0]);
        }
    }
    ,
    LONG(false){

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeAndMapFirstColumnToLong(boundStatement)", new Object[0]);
        }
    }
    ,
    ROW(false){

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeAndExtractFirstRow(boundStatement)", new Object[0]);
        }
    }
    ,
    ENTITY(false){

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeAndMapToSingleEntity(boundStatement, $L)", new Object[]{helperFieldName});
        }
    }
    ,
    OPTIONAL_ENTITY(false){

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeAndMapToOptionalEntity(boundStatement, $L)", new Object[]{helperFieldName});
        }
    }
    ,
    RESULT_SET(false){

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return execute(boundStatement)", new Object[0]);
        }
    }
    ,
    PAGING_ITERABLE(false){

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeAndMapToEntityIterable(boundStatement, $L)", new Object[]{helperFieldName});
        }
    }
    ,
    FUTURE_OF_VOID(true){

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeAsyncAndMapToVoid(boundStatement)", new Object[0]);
        }
    }
    ,
    FUTURE_OF_BOOLEAN(true){

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeAsyncAndMapWasAppliedToBoolean(boundStatement)", new Object[0]);
        }
    }
    ,
    FUTURE_OF_LONG(true){

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeAsyncAndMapFirstColumnToLong(boundStatement)", new Object[0]);
        }
    }
    ,
    FUTURE_OF_ROW(true){

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeAsyncAndExtractFirstRow(boundStatement)", new Object[0]);
        }
    }
    ,
    FUTURE_OF_ENTITY(true){

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeAsyncAndMapToSingleEntity(boundStatement, $L)", new Object[]{helperFieldName});
        }
    }
    ,
    FUTURE_OF_OPTIONAL_ENTITY(true){

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeAsyncAndMapToOptionalEntity(boundStatement, $L)", new Object[]{helperFieldName});
        }
    }
    ,
    FUTURE_OF_ASYNC_RESULT_SET(true){

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeAsync(boundStatement)", new Object[0]);
        }
    }
    ,
    FUTURE_OF_ASYNC_PAGING_ITERABLE(true){

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeAsyncAndMapToEntityIterable(boundStatement, $L)", new Object[]{helperFieldName});
        }
    }
    ,
    UNSUPPORTED(false){

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            throw new AssertionError((Object)"Should never get here");
        }
    };

    private final boolean isAsync;

    private DefaultDaoReturnTypeKind(boolean isAsync) {
        this.isAsync = isAsync;
    }

    @Override
    public String getDescription() {
        return this.name();
    }

    @Override
    public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock) {
        if (this.isAsync) {
            return CodeBlock.builder().beginControlFlow("try", new Object[0]).add(innerBlock).nextControlFlow("catch ($T t)", new Object[]{Throwable.class}).addStatement("return $T.failedFuture(t)", new Object[]{CompletableFutures.class}).endControlFlow().build();
        }
        return innerBlock;
    }
}

