/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.dao;

import com.datastax.oss.driver.api.mapper.annotations.Entity;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;

public class EntityUtils {
    public static TypeElement asEntityElement(VariableElement parameter, Map<Name, TypeElement> typeParameters) {
        return EntityUtils.asEntityElement(parameter.asType(), typeParameters);
    }

    public static TypeElement typeArgumentAsEntityElement(TypeMirror mirror, Map<Name, TypeElement> typeParameters) {
        DeclaredType declaredType = (DeclaredType)mirror;
        assert (!declaredType.getTypeArguments().isEmpty());
        return EntityUtils.asEntityElement(declaredType.getTypeArguments().get(0), typeParameters);
    }

    public static TypeElement asEntityElement(TypeMirror mirror, Map<Name, TypeElement> typeParameters) {
        Element element;
        if (mirror.getKind() == TypeKind.TYPEVAR) {
            TypeVariable typeVariable = (TypeVariable)mirror;
            Name name = typeVariable.asElement().getSimpleName();
            element = typeParameters.get(name);
            if (element == null) {
                return null;
            }
        } else if (mirror.getKind() == TypeKind.DECLARED) {
            element = ((DeclaredType)mirror).asElement();
        } else {
            return null;
        }
        if (element.getKind() != ElementKind.CLASS) {
            return null;
        }
        TypeElement typeElement = (TypeElement)element;
        if (typeElement.getAnnotation(Entity.class) == null) {
            return null;
        }
        return typeElement;
    }
}

