/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.entity;

import com.datastax.oss.driver.api.core.data.GettableByName;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.internal.mapper.processor.MethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityDefinition;
import com.datastax.oss.driver.internal.mapper.processor.entity.PropertyDefinition;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.BindableHandlingSharedCode;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.GeneratedCodePatterns;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.PropertyType;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import com.datastax.oss.driver.shaded.guava.common.collect.Maps;
import com.datastax.oss.driver.shaded.guava.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.Modifier;

public class EntityHelperGetMethodGenerator
implements MethodGenerator {
    private final EntityDefinition entityDefinition;
    private final BindableHandlingSharedCode enclosingClass;

    public EntityHelperGetMethodGenerator(EntityDefinition entityDefinition, BindableHandlingSharedCode enclosingClass, ProcessorContext context) {
        this.entityDefinition = entityDefinition;
        this.enclosingClass = enclosingClass;
    }

    @Override
    public Optional<MethodSpec> generate() {
        MethodSpec.Builder getBuilder = MethodSpec.methodBuilder((String)"get").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)ClassName.get(GettableByName.class), (String)"source", (Modifier[])new Modifier[0]).build()).returns((TypeName)this.entityDefinition.getClassName());
        ClassName returnType = this.entityDefinition.getClassName();
        String returnName = "returnValue";
        getBuilder.addStatement("$1T $2L = new $1T()", new Object[]{returnType, returnName});
        for (PropertyDefinition property : this.entityDefinition.getAllValues()) {
            PropertyType type = property.getType();
            CodeBlock cqlName = property.getCqlName();
            String setterName = property.getSetterName();
            getBuilder.addCode("\n", new Object[0]);
            if (type instanceof PropertyType.Simple) {
                TypeName typeName = ((PropertyType.Simple)type).typeName;
                String primitiveAccessor = GeneratedCodePatterns.PRIMITIVE_ACCESSORS.get(typeName);
                if (primitiveAccessor != null) {
                    getBuilder.addStatement("returnValue.$L(source.get$L($L))", new Object[]{setterName, primitiveAccessor, cqlName});
                    continue;
                }
                if (typeName instanceof ClassName) {
                    getBuilder.addStatement("returnValue.$L(source.get($L, $T.class))", new Object[]{setterName, cqlName, typeName});
                    continue;
                }
                getBuilder.addStatement("returnValue.$L(source.get($L, $L))", new Object[]{setterName, cqlName, this.enclosingClass.addGenericTypeConstant(typeName)});
                continue;
            }
            if (type instanceof PropertyType.SingleEntity) {
                ClassName entityClass = ((PropertyType.SingleEntity)type).entityName;
                String udtValueName = this.enclosingClass.getNameIndex().uniqueField("udtValue");
                String valueName = this.enclosingClass.getNameIndex().uniqueField("value");
                getBuilder.addStatement("$T $L = source.getUdtValue($L)", new Object[]{UdtValue.class, udtValueName, cqlName});
                getBuilder.beginControlFlow("if ($L != null)", new Object[]{udtValueName});
                String childHelper = this.enclosingClass.addEntityHelperField(entityClass);
                getBuilder.addStatement("$T $L = $L.get($L)", new Object[]{entityClass, valueName, childHelper, udtValueName});
                getBuilder.addStatement("returnValue.$L($L)", new Object[]{setterName, valueName});
                getBuilder.endControlFlow();
                continue;
            }
            String mappedCollectionName = this.enclosingClass.getNameIndex().uniqueField("mappedCollection");
            String rawCollectionName = this.enclosingClass.getNameIndex().uniqueField("rawCollection");
            TypeName rawCollectionType = type.asRawTypeName();
            getBuilder.addStatement("$T $L = source.get($L, $L)", new Object[]{rawCollectionType, rawCollectionName, cqlName, this.enclosingClass.addGenericTypeConstant(rawCollectionType)}).beginControlFlow("if ($L != null)", new Object[]{rawCollectionName});
            this.convertUdtsIntoEntities(rawCollectionName, mappedCollectionName, type, getBuilder);
            getBuilder.addStatement("returnValue.$L($L)", new Object[]{setterName, mappedCollectionName}).endControlFlow();
        }
        getBuilder.addStatement("return returnValue", new Object[0]);
        return Optional.of(getBuilder.build());
    }

    private void convertUdtsIntoEntities(String rawObjectName, String mappedObjectName, PropertyType type, MethodSpec.Builder getBuilder) {
        if (type instanceof PropertyType.SingleEntity) {
            ClassName entityClass = ((PropertyType.SingleEntity)type).entityName;
            String entityHelperName = this.enclosingClass.addEntityHelperField(entityClass);
            getBuilder.addStatement("$T $L = $L.get($L)", new Object[]{type.asTypeName(), mappedObjectName, entityHelperName, rawObjectName});
        } else if (type instanceof PropertyType.EntityList) {
            getBuilder.addStatement("$T $L = $T.newArrayListWithExpectedSize($L.size())", new Object[]{type.asTypeName(), mappedObjectName, Lists.class, rawObjectName});
            PropertyType mappedElementType = ((PropertyType.EntityList)type).elementType;
            TypeName rawElementType = mappedElementType.asRawTypeName();
            String rawElementName = this.enclosingClass.getNameIndex().uniqueField("rawElement");
            getBuilder.beginControlFlow("for ($T $L: $L)", new Object[]{rawElementType, rawElementName, rawObjectName});
            String mappedElementName = this.enclosingClass.getNameIndex().uniqueField("mappedElement");
            this.convertUdtsIntoEntities(rawElementName, mappedElementName, mappedElementType, getBuilder);
            getBuilder.addStatement("$L.add($L)", new Object[]{mappedObjectName, mappedElementName}).endControlFlow();
        } else if (type instanceof PropertyType.EntitySet) {
            getBuilder.addStatement("$T $L = $T.newLinkedHashSetWithExpectedSize($L.size())", new Object[]{type.asTypeName(), mappedObjectName, Sets.class, rawObjectName});
            PropertyType mappedElementType = ((PropertyType.EntitySet)type).elementType;
            TypeName rawElementType = mappedElementType.asRawTypeName();
            String rawElementName = this.enclosingClass.getNameIndex().uniqueField("rawElement");
            getBuilder.beginControlFlow("for ($T $L: $L)", new Object[]{rawElementType, rawElementName, rawObjectName});
            String mappedElementName = this.enclosingClass.getNameIndex().uniqueField("mappedElement");
            this.convertUdtsIntoEntities(rawElementName, mappedElementName, mappedElementType, getBuilder);
            getBuilder.addStatement("$L.add($L)", new Object[]{mappedObjectName, mappedElementName}).endControlFlow();
        } else if (type instanceof PropertyType.EntityMap) {
            String mappedValueName;
            String mappedKeyName;
            getBuilder.addStatement("$T $L = $T.newLinkedHashMapWithExpectedSize($L.size())", new Object[]{type.asTypeName(), mappedObjectName, Maps.class, rawObjectName});
            PropertyType mappedKeyType = ((PropertyType.EntityMap)type).keyType;
            PropertyType mappedValueType = ((PropertyType.EntityMap)type).valueType;
            String rawEntryName = this.enclosingClass.getNameIndex().uniqueField("rawEntry");
            getBuilder.beginControlFlow("for ($T $L: $L.entrySet())", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Map.Entry.class), (TypeName[])new TypeName[]{mappedKeyType.asRawTypeName(), mappedValueType.asRawTypeName()}), rawEntryName, rawObjectName});
            String rawKeyName = CodeBlock.of((String)"$L.getKey()", (Object[])new Object[]{rawEntryName}).toString();
            if (mappedKeyType instanceof PropertyType.Simple) {
                mappedKeyName = rawKeyName;
            } else {
                mappedKeyName = this.enclosingClass.getNameIndex().uniqueField("mappedKey");
                this.convertUdtsIntoEntities(rawKeyName, mappedKeyName, mappedKeyType, getBuilder);
            }
            String rawValueName = CodeBlock.of((String)"$L.getValue()", (Object[])new Object[]{rawEntryName}).toString();
            if (mappedValueType instanceof PropertyType.Simple) {
                mappedValueName = rawValueName;
            } else {
                mappedValueName = this.enclosingClass.getNameIndex().uniqueField("mappedValue");
                this.convertUdtsIntoEntities(rawValueName, mappedValueName, mappedValueType, getBuilder);
            }
            getBuilder.addStatement("$L.put($L, $L)", new Object[]{mappedObjectName, mappedKeyName, mappedValueName}).endControlFlow();
        } else {
            throw new AssertionError((Object)("Unsupported type " + type.asTypeName()));
        }
    }
}

