/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.util;

import com.datastax.oss.driver.api.mapper.annotations.HierarchyScanStrategy;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.datastax.oss.driver.shaded.guava.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

public class HierarchyScanner {
    private static final HierarchyScanStrategy defaultStrategy = ClassForDefaultScanStrategy.class.getAnnotation(HierarchyScanStrategy.class);

    public static Set<TypeMirror> resolveTypeHierarchy(TypeElement typeElement, ProcessorContext context) {
        HierarchyScanStrategyOptions hierarchyScanStrategy = HierarchyScanner.resolveHierarchyScanStrategy(typeElement, context);
        ImmutableSet.Builder hierarchy = ImmutableSet.builder();
        HierarchyScanner.traverseFullHierarchy(hierarchyScanStrategy, typeElement, context, arg_0 -> ((ImmutableSet.Builder)hierarchy).add(arg_0));
        return hierarchy.build();
    }

    private static HierarchyScanStrategyOptions resolveHierarchyScanStrategy(TypeElement classElement, ProcessorContext context) {
        HierarchyScanStrategyOptions defaultOptions = new HierarchyScanStrategyOptions(context.getElementUtils());
        AtomicReference<HierarchyScanStrategyOptions> ref = new AtomicReference<HierarchyScanStrategyOptions>(defaultOptions);
        HierarchyScanner.traverseHierarchy(defaultOptions, classElement, context, mirror -> {
            Element element = context.getTypeUtils().asElement((TypeMirror)mirror);
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!context.getClassUtils().isSame(annotationMirror.getAnnotationType(), HierarchyScanStrategy.class)) continue;
                ref.compareAndSet(defaultOptions, new HierarchyScanStrategyOptions(annotationMirror));
                return false;
            }
            return true;
        });
        return ref.get();
    }

    private static void traverseFullHierarchy(HierarchyScanStrategyOptions hierarchyScanStrategy, TypeElement classElement, ProcessorContext context, Consumer<TypeMirror> typeConsumer) {
        HierarchyScanner.traverseHierarchy(hierarchyScanStrategy, classElement, context, t -> {
            typeConsumer.accept((TypeMirror)t);
            return true;
        });
    }

    private static void traverseHierarchy(HierarchyScanStrategyOptions hierarchyScanStrategy, TypeElement classElement, ProcessorContext context, Function<TypeMirror, Boolean> typeConsumer) {
        if (!typeConsumer.apply(classElement.asType()).booleanValue() || !hierarchyScanStrategy.scanAncestors) {
            return;
        }
        LinkedHashSet interfacesToScan = Collections.emptySet();
        boolean atHighestClass = hierarchyScanStrategy.atHighest(classElement.asType());
        while (!atHighestClass) {
            TypeMirror superClass = classElement.getSuperclass();
            TypeElement superClassElement = null;
            if (superClass.getKind() == TypeKind.DECLARED) {
                superClassElement = (TypeElement)context.getTypeUtils().asElement(superClass);
                atHighestClass = hierarchyScanStrategy.atHighest(superClass);
                if (!(atHighestClass && !hierarchyScanStrategy.includeHighestAncestor || typeConsumer.apply(superClass).booleanValue())) {
                    return;
                }
            } else {
                atHighestClass = true;
            }
            LinkedHashSet newInterfacesToScan = Sets.newLinkedHashSet();
            HierarchyScanner.scanInterfaces(hierarchyScanStrategy, classElement.getInterfaces(), newInterfacesToScan, context, typeConsumer);
            HierarchyScanner.scanInterfaces(hierarchyScanStrategy, interfacesToScan, newInterfacesToScan, context, typeConsumer);
            classElement = superClassElement;
            interfacesToScan = newInterfacesToScan;
        }
        while (!interfacesToScan.isEmpty()) {
            LinkedHashSet newInterfacesToScan = Sets.newLinkedHashSet();
            HierarchyScanner.scanInterfaces(hierarchyScanStrategy, interfacesToScan, newInterfacesToScan, context, typeConsumer);
            interfacesToScan = newInterfacesToScan;
        }
    }

    private static void scanInterfaces(HierarchyScanStrategyOptions hierarchyScanStrategy, Collection<? extends TypeMirror> interfacesToScan, Set<TypeMirror> newInterfacesToScan, ProcessorContext context, Function<TypeMirror, Boolean> typeConsumer) {
        for (TypeMirror typeMirror : interfacesToScan) {
            if (typeMirror.getKind() != TypeKind.DECLARED) continue;
            TypeElement interfaceElement = (TypeElement)context.getTypeUtils().asElement(typeMirror);
            boolean atHighest = hierarchyScanStrategy.atHighest(typeMirror);
            if (!(atHighest && !hierarchyScanStrategy.includeHighestAncestor || typeConsumer.apply(typeMirror).booleanValue())) {
                return;
            }
            if (atHighest) continue;
            newInterfacesToScan.addAll(interfaceElement.getInterfaces());
        }
    }

    private static class HierarchyScanStrategyOptions {
        boolean scanAncestors = HierarchyScanner.access$000().scanAncestors();
        TypeMirror highestAncestor = null;
        boolean includeHighestAncestor = HierarchyScanner.access$000().includeHighestAncestor();

        HierarchyScanStrategyOptions(Elements elements) {
            this.highestAncestor = elements.getTypeElement(defaultStrategy.highestAncestor().getName()).asType();
        }

        HierarchyScanStrategyOptions(AnnotationMirror annotationMirror) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (entry.getKey().getSimpleName().contentEquals("scanAncestors")) {
                    this.scanAncestors = (Boolean)entry.getValue().getValue();
                    continue;
                }
                if (entry.getKey().getSimpleName().contentEquals("highestAncestor")) {
                    this.highestAncestor = (TypeMirror)entry.getValue().getValue();
                    continue;
                }
                if (!entry.getKey().getSimpleName().contentEquals("includeHighestAncestor")) continue;
                this.includeHighestAncestor = (Boolean)entry.getValue().getValue();
            }
        }

        boolean atHighest(TypeMirror mirror) {
            return this.highestAncestor != null && this.highestAncestor.equals(mirror);
        }
    }

    @HierarchyScanStrategy
    private static final class ClassForDefaultScanStrategy {
        private ClassForDefaultScanStrategy() {
        }
    }
}

