/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.dao;

import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.mapper.annotations.CqlName;
import com.datastax.oss.driver.api.mapper.annotations.Select;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoImplementationSharedCode;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoMethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoReturnType;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoReturnTypeKind;
import com.datastax.oss.driver.internal.mapper.processor.dao.DefaultDaoReturnTypeKind;
import com.datastax.oss.driver.internal.mapper.processor.dao.EntityUtils;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityDefinition;
import com.datastax.oss.driver.internal.mapper.processor.entity.PropertyDefinition;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.GeneratedCodePatterns;
import com.datastax.oss.driver.shaded.guava.common.base.Splitter;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public class DaoSelectMethodGenerator
extends DaoMethodGenerator {
    private static final Splitter ON_SPACES = Splitter.on((char)' ').omitEmptyStrings();

    public DaoSelectMethodGenerator(ExecutableElement methodElement, Map<Name, TypeElement> typeParameters, TypeElement processedType, DaoImplementationSharedCode enclosingClass, ProcessorContext context) {
        super(methodElement, typeParameters, processedType, enclosingClass, context);
    }

    protected Set<DaoReturnTypeKind> getSupportedReturnTypes() {
        return ImmutableSet.of((Object)DefaultDaoReturnTypeKind.ENTITY, (Object)DefaultDaoReturnTypeKind.OPTIONAL_ENTITY, (Object)DefaultDaoReturnTypeKind.FUTURE_OF_ENTITY, (Object)DefaultDaoReturnTypeKind.FUTURE_OF_OPTIONAL_ENTITY, (Object)DefaultDaoReturnTypeKind.PAGING_ITERABLE, (Object)DefaultDaoReturnTypeKind.FUTURE_OF_ASYNC_PAGING_ITERABLE, (Object[])new DaoReturnTypeKind[]{DefaultDaoReturnTypeKind.MAPPED_REACTIVE_RESULT_SET, DefaultDaoReturnTypeKind.CUSTOM});
    }

    @Override
    public boolean requiresReactive() {
        DaoReturnType returnType = this.parseAndValidateReturnType(this.getSupportedReturnTypes(), Select.class.getSimpleName());
        if (returnType == null) {
            return false;
        }
        return returnType.requiresReactive();
    }

    @Override
    public Optional<MethodSpec> generate() {
        List<Object> primaryKeyParameters;
        List<Object> freeFormParameters;
        DaoReturnType returnType = this.parseAndValidateReturnType(this.getSupportedReturnTypes(), Select.class.getSimpleName());
        if (returnType == null) {
            return Optional.empty();
        }
        TypeElement entityElement = returnType.getEntityElement();
        EntityDefinition entityDefinition = this.context.getEntityFactory().getDefinition(entityElement);
        List<? extends VariableElement> parameters = this.methodElement.getParameters();
        VariableElement boundStatementFunction = this.findBoundStatementFunction(this.methodElement);
        if (boundStatementFunction != null) {
            parameters = parameters.subList(0, parameters.size() - 1);
        }
        Select selectAnnotation = this.methodElement.getAnnotation(Select.class);
        assert (selectAnnotation != null);
        String customClause = selectAnnotation.customWhereClause();
        if (parameters.isEmpty()) {
            freeFormParameters = Collections.emptyList();
            primaryKeyParameters = freeFormParameters;
        } else if (customClause.isEmpty()) {
            int primaryKeyEnd;
            int firstNamedParameter = parameters.size();
            for (int i = 0; i < parameters.size(); ++i) {
                if (parameters.get(i).getAnnotation(CqlName.class) == null) continue;
                firstNamedParameter = i;
                break;
            }
            if ((primaryKeyEnd = Math.min(firstNamedParameter, entityDefinition.getPrimaryKey().size())) >= parameters.size()) {
                primaryKeyParameters = parameters;
                freeFormParameters = Collections.emptyList();
            } else {
                primaryKeyParameters = parameters.subList(0, primaryKeyEnd);
                freeFormParameters = parameters.subList(primaryKeyEnd, parameters.size());
            }
        } else {
            primaryKeyParameters = Collections.emptyList();
            freeFormParameters = parameters;
        }
        if (!primaryKeyParameters.isEmpty() && !EntityUtils.areParametersValid(entityElement, entityDefinition, primaryKeyParameters, Select.class, this.context, this.methodElement, this.processedType, "don't use a custom clause")) {
            return Optional.empty();
        }
        String helperFieldName = this.enclosingClass.addEntityHelperField(ClassName.get((TypeElement)entityElement));
        String statementName = this.enclosingClass.addPreparedStatement(this.methodElement, (methodBuilder, requestName) -> this.generateSelectRequest((MethodSpec.Builder)methodBuilder, (String)requestName, helperFieldName, primaryKeyParameters.size()));
        CodeBlock.Builder createStatementBlock = CodeBlock.builder();
        createStatementBlock.addStatement("$T boundStatementBuilder = $L.boundStatementBuilder()", new Object[]{BoundStatementBuilder.class, statementName});
        this.populateBuilderWithStatementAttributes(createStatementBlock, this.methodElement);
        this.populateBuilderWithFunction(createStatementBlock, boundStatementFunction);
        if (!primaryKeyParameters.isEmpty()) {
            List<CodeBlock> primaryKeyNames = entityDefinition.getPrimaryKey().stream().map(PropertyDefinition::getCqlName).collect(Collectors.toList()).subList(0, primaryKeyParameters.size());
            GeneratedCodePatterns.bindParameters(primaryKeyParameters, primaryKeyNames, createStatementBlock, this.enclosingClass, this.context, false);
        }
        if (!freeFormParameters.isEmpty()) {
            if (this.validateCqlNamesPresent(freeFormParameters)) {
                GeneratedCodePatterns.bindParameters(freeFormParameters, createStatementBlock, this.enclosingClass, this.context, false);
            } else {
                return Optional.empty();
            }
        }
        createStatementBlock.add("\n", new Object[0]).addStatement("$T boundStatement = boundStatementBuilder.build()", new Object[]{BoundStatement.class});
        return this.crudMethod(createStatementBlock, returnType, helperFieldName);
    }

    private void generateSelectRequest(MethodSpec.Builder methodBuilder, String requestName, String helperFieldName, int numberOfPrimaryKeyPartsInWhereClause) {
        Select annotation = this.methodElement.getAnnotation(Select.class);
        String customWhereClause = annotation.customWhereClause();
        if (customWhereClause.isEmpty()) {
            methodBuilder.addCode("$[$T $L = $L.selectByPrimaryKeyParts($L)", new Object[]{SimpleStatement.class, requestName, helperFieldName, numberOfPrimaryKeyPartsInWhereClause});
        } else {
            methodBuilder.addCode("$[$T $L = $L.selectStart().whereRaw($S)", new Object[]{SimpleStatement.class, requestName, helperFieldName, customWhereClause});
        }
        this.maybeAddSimpleClause(annotation.limit(), Integer::parseInt, "limit", "limit", methodBuilder);
        this.maybeAddSimpleClause(annotation.perPartitionLimit(), Integer::parseInt, "perPartitionLimit", "perPartitionLimit", methodBuilder);
        for (String orderingSpec : annotation.orderBy()) {
            this.addOrdering(orderingSpec, methodBuilder);
        }
        for (String groupByColumn : annotation.groupBy()) {
            methodBuilder.addCode(".groupBy($S)", new Object[]{groupByColumn});
        }
        if (annotation.allowFiltering()) {
            methodBuilder.addCode(".allowFiltering()", new Object[0]);
        }
        methodBuilder.addCode(".build();$]\n", new Object[0]);
    }

    private void addOrdering(String orderingSpec, MethodSpec.Builder methodBuilder) {
        ClusteringOrder clusteringOrder;
        List tokens = ON_SPACES.splitToList((CharSequence)orderingSpec);
        if (tokens.size() != 2 || (clusteringOrder = this.parseClusteringOrder((String)tokens.get(1))) == null) {
            this.context.getMessager().error(this.methodElement, "Can't parse ordering '%s', expected a column name followed by ASC or DESC", orderingSpec);
            return;
        }
        methodBuilder.addCode(".orderBy($S, $T.$L)", new Object[]{tokens.get(0), ClusteringOrder.class, clusteringOrder});
    }

    private ClusteringOrder parseClusteringOrder(String spec) {
        try {
            return ClusteringOrder.valueOf((String)spec.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

