/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor;

import edu.umd.cs.findbugs.annotations.NonNull;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public class DecoratedMessager {
    private final Messager messager;

    public DecoratedMessager(Messager messager) {
        this.messager = messager;
    }

    public void warn(String template, Object ... arguments) {
        this.messager.printMessage(Diagnostic.Kind.WARNING, String.format(template, arguments));
    }

    public void warn(TypeElement typeElement, String template, Object ... arguments) {
        this.messager.printMessage(Diagnostic.Kind.WARNING, String.format(template, arguments), typeElement);
    }

    public void error(TypeElement typeElement, String template, Object ... arguments) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(template, arguments), typeElement);
    }

    public void warn(Element targetElement, TypeElement processedType, String template, Object ... arguments) {
        new ElementMessager(targetElement, processedType).print(Diagnostic.Kind.WARNING, template, arguments);
    }

    public void error(Element targetElement, TypeElement processedType, String template, Object ... arguments) {
        new ElementMessager(targetElement, processedType).print(Diagnostic.Kind.ERROR, template, arguments);
    }

    private class ElementMessager {
        private final Element actualTargetElement;
        private final String locationInfo;

        ElementMessager(@NonNull Element intendedTargetElement, TypeElement processedType) {
            switch (intendedTargetElement.getKind()) {
                case CLASS: 
                case INTERFACE: {
                    if (processedType.equals(intendedTargetElement) || this.isSourceFile((TypeElement)intendedTargetElement)) {
                        this.actualTargetElement = intendedTargetElement;
                        this.locationInfo = "";
                        break;
                    }
                    this.actualTargetElement = processedType;
                    this.locationInfo = String.format("[Ancestor %s]", intendedTargetElement.getSimpleName());
                    break;
                }
                case FIELD: 
                case METHOD: 
                case CONSTRUCTOR: {
                    TypeElement declaringType = (TypeElement)intendedTargetElement.getEnclosingElement();
                    if (processedType.equals(declaringType) || this.isSourceFile(declaringType)) {
                        this.actualTargetElement = intendedTargetElement;
                        this.locationInfo = "";
                        break;
                    }
                    this.actualTargetElement = processedType;
                    this.locationInfo = String.format("[%s inherited from %s] ", intendedTargetElement, declaringType.getSimpleName());
                    break;
                }
                case PARAMETER: {
                    ExecutableElement method = (ExecutableElement)intendedTargetElement.getEnclosingElement();
                    TypeElement declaringType = (TypeElement)method.getEnclosingElement();
                    if (processedType.equals(declaringType) || this.isSourceFile(declaringType)) {
                        this.actualTargetElement = intendedTargetElement;
                        this.locationInfo = "";
                        break;
                    }
                    this.actualTargetElement = processedType;
                    this.locationInfo = String.format("[Parameter %s of %s inherited from %s] ", intendedTargetElement.getSimpleName(), method.getSimpleName(), declaringType.getSimpleName());
                    break;
                }
                default: {
                    this.actualTargetElement = intendedTargetElement;
                    this.locationInfo = "";
                }
            }
        }

        void print(Diagnostic.Kind level, String template, Object ... arguments) {
            DecoratedMessager.this.messager.printMessage(level, String.format(this.locationInfo + template, arguments), this.actualTargetElement);
        }

        private boolean isSourceFile(TypeElement element) {
            try {
                Class.forName(element.getQualifiedName().toString());
                return false;
            }
            catch (ClassNotFoundException e) {
                return true;
            }
        }
    }
}

