/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.dao;

import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.mapper.MapperContext;
import com.datastax.oss.driver.api.mapper.annotations.Dao;
import com.datastax.oss.driver.api.mapper.annotations.DefaultNullSavingStrategy;
import com.datastax.oss.driver.api.mapper.entity.saving.NullSavingStrategy;
import com.datastax.oss.driver.internal.core.util.concurrent.BlockingOperation;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.driver.internal.mapper.DaoBase;
import com.datastax.oss.driver.internal.mapper.processor.GeneratedNames;
import com.datastax.oss.driver.internal.mapper.processor.MethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.SingleFileCodeGenerator;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoImplementationSharedCode;
import com.datastax.oss.driver.internal.mapper.processor.dao.LoggingGenerator;
import com.datastax.oss.driver.internal.mapper.processor.dao.NullSavingStrategyValidation;
import com.datastax.oss.driver.internal.mapper.processor.util.HierarchyScanner;
import com.datastax.oss.driver.internal.mapper.processor.util.NameIndex;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.GenericTypeConstantGenerator;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.datastax.oss.driver.shaded.guava.common.collect.Maps;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;

public class DaoImplementationGenerator
extends SingleFileCodeGenerator
implements DaoImplementationSharedCode {
    private static final TypeName PREPARED_STATEMENT_STAGE = ParameterizedTypeName.get(CompletionStage.class, (Type[])new Type[]{PreparedStatement.class});
    private final TypeElement interfaceElement;
    private final ClassName implementationName;
    private final NameIndex nameIndex = new NameIndex();
    private final GenericTypeConstantGenerator genericTypeConstantGenerator = new GenericTypeConstantGenerator(this.nameIndex);
    private final Map<ClassName, String> entityHelperFields = new LinkedHashMap<ClassName, String>();
    private final List<GeneratedPreparedStatement> preparedStatements = new ArrayList<GeneratedPreparedStatement>();
    private final List<GeneratedQueryProvider> queryProviders = new ArrayList<GeneratedQueryProvider>();
    private final NullSavingStrategyValidation nullSavingStrategyValidation;
    private final Map<TypeMirror, Map<Name, TypeElement>> typeMappingsForInterface = Maps.newHashMap();
    private final Set<TypeMirror> interfaces;
    private final Map<Class<? extends Annotation>, Annotation> annotations;
    private static final Set<Class<? extends Annotation>> ANNOTATIONS_TO_SCAN = ImmutableSet.of(DefaultNullSavingStrategy.class);

    public DaoImplementationGenerator(TypeElement interfaceElement, ProcessorContext context) {
        super(context);
        this.interfaceElement = interfaceElement;
        this.interfaces = HierarchyScanner.resolveTypeHierarchy(interfaceElement, context);
        this.annotations = this.scanAnnotations();
        this.implementationName = GeneratedNames.daoImplementation(interfaceElement);
        this.nullSavingStrategyValidation = new NullSavingStrategyValidation(context);
    }

    private Map<Class<? extends Annotation>, Annotation> scanAnnotations() {
        HashMap annotations = Maps.newHashMap();
        for (TypeMirror mirror : this.interfaces) {
            Element element = this.context.getTypeUtils().asElement(mirror);
            for (Class<? extends Annotation> annotationClass : ANNOTATIONS_TO_SCAN) {
                Annotation annotation = element.getAnnotation(annotationClass);
                if (annotation == null) continue;
                annotations.putIfAbsent(annotationClass, annotation);
            }
        }
        return ImmutableMap.copyOf((Map)annotations);
    }

    private <A extends Annotation> Optional<A> getAnnotation(Class<A> annotationClass) {
        return Optional.ofNullable((Annotation)annotationClass.cast(this.annotations.get(annotationClass)));
    }

    @Override
    public NameIndex getNameIndex() {
        return this.nameIndex;
    }

    @Override
    public String addGenericTypeConstant(TypeName type) {
        return this.genericTypeConstantGenerator.add(type);
    }

    @Override
    public String addEntityHelperField(ClassName entityClassName) {
        ClassName helperClass = GeneratedNames.entityHelper(entityClassName);
        return this.entityHelperFields.computeIfAbsent(helperClass, k -> {
            String baseName = Introspector.decapitalize(entityClassName.simpleName()) + "Helper";
            return this.nameIndex.uniqueField(baseName);
        });
    }

    @Override
    public String addPreparedStatement(ExecutableElement methodElement, BiConsumer<MethodSpec.Builder, String> simpleStatementGenerator) {
        String fieldName = this.nameIndex.uniqueField(methodElement.getSimpleName().toString() + "Statement");
        this.preparedStatements.add(new GeneratedPreparedStatement(methodElement, fieldName, simpleStatementGenerator));
        return fieldName;
    }

    @Override
    public String addQueryProvider(ExecutableElement methodElement, TypeMirror providerClass, List<ClassName> entityHelperTypes) {
        String fieldName = this.nameIndex.uniqueField(methodElement.getSimpleName().toString() + "Invoker");
        ArrayList<String> entityHelperNames = new ArrayList<String>();
        for (ClassName type : entityHelperTypes) {
            entityHelperNames.add(this.addEntityHelperField(type));
        }
        this.queryProviders.add(new GeneratedQueryProvider(fieldName, providerClass, entityHelperNames));
        return fieldName;
    }

    @Override
    public Optional<NullSavingStrategy> getNullSavingStrategy() {
        return this.getAnnotation(DefaultNullSavingStrategy.class).map(DefaultNullSavingStrategy::value);
    }

    @Override
    protected ClassName getPrincipalTypeName() {
        return this.implementationName;
    }

    private Map<Name, TypeElement> parseTypeParameters(TypeMirror mirror) {
        HashMap typeParameters = Maps.newHashMap();
        Map childTypeParameters = this.typeMappingsForInterface.getOrDefault(mirror, Collections.emptyMap());
        if (mirror instanceof DeclaredType) {
            TypeElement element = (TypeElement)this.context.getTypeUtils().asElement(mirror);
            DeclaredType declaredType = (DeclaredType)mirror;
            for (int i = 0; i < declaredType.getTypeArguments().size(); ++i) {
                Name name = element.getTypeParameters().get(i).getSimpleName();
                TypeMirror typeArgument = declaredType.getTypeArguments().get(i);
                if (typeArgument instanceof DeclaredType) {
                    Element concreteType = ((DeclaredType)typeArgument).asElement();
                    typeParameters.put(name, (TypeElement)concreteType);
                    continue;
                }
                if (!(typeArgument instanceof TypeVariable)) continue;
                Name typeVariableName = ((TypeVariable)typeArgument).asElement().getSimpleName();
                if (childTypeParameters.containsKey(typeVariableName)) {
                    typeParameters.put(name, (TypeElement)childTypeParameters.get(typeVariableName));
                    continue;
                }
                this.context.getMessager().error((Element)element, this.interfaceElement, "Could not resolve type parameter %s on %s from child interfaces. This error usually means an interface was inappropriately annotated with @%s. Interfaces should only be annotated with @%s if all generic type variables are declared.", name, mirror, Dao.class.getSimpleName(), Dao.class.getSimpleName());
            }
            for (TypeMirror typeMirror : element.getInterfaces()) {
                if (!(typeMirror instanceof DeclaredType)) continue;
                Map typeMappingsForParent = this.typeMappingsForInterface.computeIfAbsent(typeMirror, k -> Maps.newHashMap());
                DeclaredType parentInterfaceType = (DeclaredType)typeMirror;
                for (TypeMirror typeMirror2 : parentInterfaceType.getTypeArguments()) {
                    TypeVariable parentTypeVariable;
                    Name parentTypeName;
                    TypeElement typeElement;
                    if (!(typeMirror2 instanceof TypeVariable) || (typeElement = (TypeElement)typeParameters.get(parentTypeName = (parentTypeVariable = (TypeVariable)typeMirror2).asElement().getSimpleName())) == null) continue;
                    typeMappingsForParent.put(parentTypeName, typeElement);
                }
            }
        }
        return typeParameters;
    }

    @Override
    protected JavaFile.Builder getContents() {
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((ClassName)this.implementationName).addJavadoc("Generated by the DataStax driver mapper, do not edit directly.\n", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(this.getDaoParentClass()).addSuperinterface((TypeName)ClassName.get((TypeElement)this.interfaceElement));
        for (TypeMirror mirror : this.interfaces) {
            TypeElement parentInterfaceElement = (TypeElement)this.context.getTypeUtils().asElement(mirror);
            Map<Name, TypeElement> typeParameters = this.parseTypeParameters(mirror);
            for (Element element : parentInterfaceElement.getEnclosedElements()) {
                ExecutableElement methodElement;
                Set<Modifier> modifiers;
                if (element.getKind() != ElementKind.METHOD || (modifiers = (methodElement = (ExecutableElement)element).getModifiers()).contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.DEFAULT)) continue;
                Optional<MethodGenerator> maybeGenerator = this.context.getCodeGeneratorFactory().newDaoImplementationMethod(methodElement, typeParameters, this.interfaceElement, this);
                if (!maybeGenerator.isPresent()) {
                    this.context.getMessager().error(methodElement, this.interfaceElement, "Unrecognized method signature: no implementation will be generated", new Object[0]);
                    continue;
                }
                maybeGenerator.flatMap(MethodGenerator::generate).ifPresent(arg_0 -> ((TypeSpec.Builder)classBuilder).addMethod(arg_0));
            }
        }
        this.genericTypeConstantGenerator.generate(classBuilder);
        MethodSpec.Builder initAsyncBuilder = this.getInitAsyncContents();
        MethodSpec.Builder initBuilder = this.getInitContents();
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(MapperContext.class, "context", new Modifier[0]).addStatement("super(context)", new Object[0]);
        this.context.getLoggingGenerator().addLoggerField(classBuilder, this.implementationName);
        for (Map.Entry<ClassName, String> entry : this.entityHelperFields.entrySet()) {
            ClassName className = entry.getKey();
            String fieldName = entry.getValue();
            classBuilder.addField(FieldSpec.builder((TypeName)className, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
            constructorBuilder.addParameter((TypeName)className, fieldName, new Modifier[0]).addStatement("this.$1L = $1L", new Object[]{fieldName});
        }
        for (GeneratedPreparedStatement preparedStatement : this.preparedStatements) {
            classBuilder.addField(FieldSpec.builder(PreparedStatement.class, (String)preparedStatement.fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
            constructorBuilder.addParameter(PreparedStatement.class, preparedStatement.fieldName, new Modifier[0]).addStatement("this.$1L = $1L", new Object[]{preparedStatement.fieldName});
        }
        for (GeneratedQueryProvider queryProvider : this.queryProviders) {
            TypeName typeName = TypeName.get((TypeMirror)queryProvider.providerClass);
            classBuilder.addField(typeName, queryProvider.fieldName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            constructorBuilder.addParameter(typeName, queryProvider.fieldName, new Modifier[0]).addStatement("this.$1L = $1L", new Object[]{queryProvider.fieldName});
        }
        classBuilder.addMethod(initAsyncBuilder.build());
        classBuilder.addMethod(initBuilder.build());
        classBuilder.addMethod(constructorBuilder.build());
        return JavaFile.builder((String)this.implementationName.packageName(), (TypeSpec)classBuilder.build());
    }

    @NonNull
    protected Class<?> getDaoParentClass() {
        return DaoBase.class;
    }

    private MethodSpec.Builder getInitAsyncContents() {
        MethodSpec.Builder initAsyncBuilder = MethodSpec.methodBuilder((String)"initAsync").returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(CompletableFuture.class), (TypeName[])new TypeName[]{ClassName.get((TypeElement)this.interfaceElement)})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(MapperContext.class, "context", new Modifier[0]);
        LoggingGenerator loggingGenerator = this.context.getLoggingGenerator();
        loggingGenerator.debug(initAsyncBuilder, "[{}] Initializing new instance for keyspace = {} and table = {}", CodeBlock.of((String)"context.getSession().getName()", (Object[])new Object[0]), CodeBlock.of((String)"context.getKeyspaceId()", (Object[])new Object[0]), CodeBlock.of((String)"context.getTableId()", (Object[])new Object[0]));
        this.generateProtocolVersionCheck(initAsyncBuilder);
        initAsyncBuilder.beginControlFlow("try", new Object[0]);
        CodeBlock.Builder newDaoStatement = CodeBlock.builder();
        newDaoStatement.add("new $1T(context$>$>", new Object[]{this.implementationName});
        initAsyncBuilder.addComment("Initialize all entity helpers", new Object[0]);
        for (Map.Entry<ClassName, String> entry : this.entityHelperFields.entrySet()) {
            ClassName fieldTypeName = entry.getKey();
            String fieldName = entry.getValue();
            initAsyncBuilder.addStatement("$1T $2L = new $1T(context)", new Object[]{fieldTypeName, fieldName});
            this.generateValidationCheck(initAsyncBuilder, fieldName);
            newDaoStatement.add(",\n$L", new Object[]{fieldName});
        }
        initAsyncBuilder.addStatement("$T<$T> prepareStages = new $T<>()", new Object[]{List.class, PREPARED_STATEMENT_STAGE, ArrayList.class});
        for (GeneratedPreparedStatement preparedStatement : this.preparedStatements) {
            initAsyncBuilder.addComment("Prepare the statement for `$L`:", new Object[]{preparedStatement.methodElement.toString()});
            String simpleStatementName = preparedStatement.fieldName + "_simple";
            preparedStatement.simpleStatementGenerator.accept(initAsyncBuilder, simpleStatementName);
            loggingGenerator.debug(initAsyncBuilder, String.format("[{}] Preparing query `{}` for method %s", preparedStatement.methodElement.toString()), CodeBlock.of((String)"context.getSession().getName()", (Object[])new Object[0]), CodeBlock.of((String)"$L.getQuery()", (Object[])new Object[]{simpleStatementName}));
            initAsyncBuilder.addStatement("$T $L = prepare($L, context)", new Object[]{PREPARED_STATEMENT_STAGE, preparedStatement.fieldName, simpleStatementName}).addStatement("prepareStages.add($L)", new Object[]{preparedStatement.fieldName});
            newDaoStatement.add(",\n$T.getCompleted($L)", new Object[]{CompletableFutures.class, preparedStatement.fieldName});
        }
        initAsyncBuilder.addComment("Initialize all method invokers", new Object[0]);
        for (GeneratedQueryProvider queryProvider : this.queryProviders) {
            initAsyncBuilder.addCode("$[$1T $2L = new $1T(context", new Object[]{queryProvider.providerClass, queryProvider.fieldName});
            for (String helperName : queryProvider.entityHelperNames) {
                initAsyncBuilder.addCode(", $L", new Object[]{helperName});
            }
            initAsyncBuilder.addCode(");$]\n", new Object[0]);
            newDaoStatement.add(",\n$L", new Object[]{queryProvider.fieldName});
        }
        newDaoStatement.add(")", new Object[0]);
        initAsyncBuilder.addComment("Build the DAO when all statements are prepared", new Object[0]).addCode("$[return $T.allSuccessful(prepareStages)", new Object[]{CompletableFutures.class}).addCode("\n.thenApply(v -> ($T) ", new Object[]{this.interfaceElement}).addCode(newDaoStatement.build()).addCode(")\n$<$<.toCompletableFuture();$]\n", new Object[0]).nextControlFlow("catch ($T t)", new Object[]{Throwable.class}).addStatement("return $T.failedFuture(t)", new Object[]{CompletableFutures.class}).endControlFlow();
        return initAsyncBuilder;
    }

    private void generateValidationCheck(MethodSpec.Builder initAsyncBuilder, String fieldName) {
        initAsyncBuilder.beginControlFlow("if (($1T)context.getCustomState().get($2S))", new Object[]{Boolean.class, "datastax.mapper.schemaValidationEnabled"});
        initAsyncBuilder.addStatement("$1L.validateEntityFields()", new Object[]{fieldName});
        initAsyncBuilder.endControlFlow();
    }

    private void generateProtocolVersionCheck(MethodSpec.Builder builder) {
        DefaultNullSavingStrategy interfaceAnnotation;
        List<ExecutableElement> methodElements = this.preparedStatements.stream().map(v -> v.methodElement).collect(Collectors.toList());
        if (this.nullSavingStrategyValidation.hasDoNotSetOnAnyLevel(methodElements, interfaceAnnotation = (DefaultNullSavingStrategy)this.getAnnotation(DefaultNullSavingStrategy.class).orElse(null))) {
            builder.addStatement("throwIfProtocolVersionV3(context)", new Object[0]);
        }
    }

    private MethodSpec.Builder getInitContents() {
        return MethodSpec.methodBuilder((String)"init").returns((TypeName)ClassName.get((TypeElement)this.interfaceElement)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(MapperContext.class, "context", new Modifier[0]).addStatement("$T.checkNotDriverThread()", new Object[]{BlockingOperation.class}).addStatement("return $T.getUninterruptibly(initAsync(context))", new Object[]{CompletableFutures.class});
    }

    private static class GeneratedQueryProvider {
        final String fieldName;
        final TypeMirror providerClass;
        final List<String> entityHelperNames;

        GeneratedQueryProvider(String fieldName, TypeMirror providerClass, List<String> entityHelperNames) {
            this.fieldName = fieldName;
            this.providerClass = providerClass;
            this.entityHelperNames = entityHelperNames;
        }
    }

    private static class GeneratedPreparedStatement {
        final ExecutableElement methodElement;
        final String fieldName;
        final BiConsumer<MethodSpec.Builder, String> simpleStatementGenerator;

        GeneratedPreparedStatement(ExecutableElement methodElement, String fieldName, BiConsumer<MethodSpec.Builder, String> simpleStatementGenerator) {
            this.methodElement = methodElement;
            this.fieldName = fieldName;
            this.simpleStatementGenerator = simpleStatementGenerator;
        }
    }
}

