/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.util.generation;

import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.mapper.annotations.CqlName;
import com.datastax.oss.driver.api.mapper.entity.saving.NullSavingStrategy;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.BindableHandlingSharedCode;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.PropertyType;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import com.datastax.oss.driver.shaded.guava.common.collect.Maps;
import com.datastax.oss.driver.shaded.guava.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;

public class GeneratedCodePatterns {
    public static final Map<TypeName, String> PRIMITIVE_ACCESSORS = ImmutableMap.builder().put((Object)TypeName.BOOLEAN, (Object)"Boolean").put((Object)TypeName.BYTE, (Object)"Byte").put((Object)TypeName.DOUBLE, (Object)"Double").put((Object)TypeName.FLOAT, (Object)"Float").put((Object)TypeName.INT, (Object)"Int").put((Object)TypeName.LONG, (Object)"Long").put((Object)TypeName.SHORT, (Object)"Short").build();
    private static final String NULL_SAVING_STRATEGY = "nullSavingStrategy";

    public static MethodSpec.Builder override(ExecutableElement interfaceMethod) {
        return GeneratedCodePatterns.override(interfaceMethod, Collections.emptyMap());
    }

    public static MethodSpec.Builder override(ExecutableElement interfaceMethod, Map<Name, TypeElement> typeParameters) {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)interfaceMethod.getSimpleName().toString()).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(GeneratedCodePatterns.getTypeName(interfaceMethod.getReturnType(), typeParameters));
        for (VariableElement variableElement : interfaceMethod.getParameters()) {
            TypeName type = GeneratedCodePatterns.getTypeName(variableElement.asType(), typeParameters);
            result.addParameter(type, variableElement.getSimpleName().toString(), new Modifier[0]);
        }
        return result;
    }

    private static TypeName getTypeName(TypeMirror mirror, Map<Name, TypeElement> typeParameters) {
        if (mirror.getKind() == TypeKind.TYPEVAR) {
            TypeVariable typeVariable = (TypeVariable)mirror;
            Name name = typeVariable.asElement().getSimpleName();
            TypeElement element = typeParameters.get(name);
            return ClassName.get((TypeElement)element);
        }
        if (mirror.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)mirror;
            TypeElement element = (TypeElement)declaredType.asElement();
            if (declaredType.getTypeArguments().size() == 0) {
                return ClassName.get((TypeElement)element);
            }
            TypeName[] types = new TypeName[declaredType.getTypeArguments().size()];
            for (int i = 0; i < declaredType.getTypeArguments().size(); ++i) {
                TypeMirror typeArgument = declaredType.getTypeArguments().get(i);
                types[i] = GeneratedCodePatterns.getTypeName(typeArgument, typeParameters);
            }
            return ParameterizedTypeName.get((ClassName)ClassName.get((TypeElement)element), (TypeName[])types);
        }
        return ClassName.get((TypeMirror)mirror);
    }

    public static void addFinalFieldAndConstructorArgument(TypeName fieldType, String fieldName, TypeSpec.Builder classBuilder, MethodSpec.Builder constructorBuilder) {
        classBuilder.addField(FieldSpec.builder((TypeName)fieldType, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
        constructorBuilder.addParameter(fieldType, fieldName, new Modifier[0]).addStatement("this.$1L = $1L", new Object[]{fieldName});
    }

    public static void bindParameters(@NonNull List<? extends VariableElement> parameters, CodeBlock.Builder methodBuilder, BindableHandlingSharedCode enclosingClass, ProcessorContext context, boolean useNullSavingStrategy) {
        ArrayList<CodeBlock> bindMarkerNames = new ArrayList<CodeBlock>();
        for (VariableElement variableElement : parameters) {
            CqlName cqlName = variableElement.getAnnotation(CqlName.class);
            String parameterName = cqlName == null ? variableElement.getSimpleName().toString() : cqlName.value();
            bindMarkerNames.add(CodeBlock.of((String)"$S", (Object[])new Object[]{parameterName}));
        }
        GeneratedCodePatterns.bindParameters(parameters, bindMarkerNames, methodBuilder, enclosingClass, context, useNullSavingStrategy);
    }

    public static void bindParameters(@NonNull List<? extends VariableElement> parameters, @NonNull List<CodeBlock> bindMarkerNames, CodeBlock.Builder methodBuilder, BindableHandlingSharedCode enclosingClass, ProcessorContext context, boolean useNullSavingStrategy) {
        assert (bindMarkerNames.size() == parameters.size());
        for (int i = 0; i < parameters.size(); ++i) {
            VariableElement parameter = parameters.get(i);
            String parameterName = parameter.getSimpleName().toString();
            PropertyType type = PropertyType.parse(parameter.asType(), context);
            GeneratedCodePatterns.setValue(bindMarkerNames.get(i), type, CodeBlock.of((String)"$L", (Object[])new Object[]{parameterName}), "boundStatementBuilder", methodBuilder, enclosingClass, useNullSavingStrategy);
        }
    }

    public static void setValue(CodeBlock cqlName, PropertyType type, CodeBlock valueExtractor, String targetName, CodeBlock.Builder methodBuilder, BindableHandlingSharedCode enclosingClass) {
        GeneratedCodePatterns.setValue(cqlName, type, valueExtractor, targetName, methodBuilder, enclosingClass, false);
    }

    public static void setValue(CodeBlock cqlName, PropertyType type, CodeBlock valueExtractor, String targetName, CodeBlock.Builder methodBuilder, BindableHandlingSharedCode enclosingClass, boolean useNullSavingStrategy) {
        methodBuilder.add("\n", new Object[0]);
        if (type instanceof PropertyType.Simple) {
            TypeName typeName = ((PropertyType.Simple)type).typeName;
            String primitiveAccessor = PRIMITIVE_ACCESSORS.get(typeName);
            if (primitiveAccessor != null) {
                methodBuilder.addStatement("$1L = $1L.set$2L($3L, $4L)", new Object[]{targetName, primitiveAccessor, cqlName, valueExtractor});
            } else if (typeName instanceof ClassName) {
                GeneratedCodePatterns.generateSetWithClass(cqlName, valueExtractor, targetName, methodBuilder, typeName, useNullSavingStrategy);
            } else {
                GeneratedCodePatterns.generateParameterizedSet(cqlName, valueExtractor, targetName, methodBuilder, typeName, enclosingClass, useNullSavingStrategy);
            }
        } else if (type instanceof PropertyType.SingleEntity) {
            ClassName entityClass = ((PropertyType.SingleEntity)type).entityName;
            String udtTypeName = enclosingClass.getNameIndex().uniqueField("udtType");
            String udtValueName = enclosingClass.getNameIndex().uniqueField("udtValue");
            String valueName = enclosingClass.getNameIndex().uniqueField("value");
            methodBuilder.addStatement("$T $L = $L", new Object[]{entityClass, valueName, valueExtractor}).beginControlFlow("if ($L != null)", new Object[]{valueName}).addStatement("$1T $2L = ($1T) $3L.getType($4L)", new Object[]{UserDefinedType.class, udtTypeName, targetName, cqlName}).addStatement("$T $L = $L.newValue()", new Object[]{UdtValue.class, udtValueName, udtTypeName});
            String childHelper = enclosingClass.addEntityHelperField(entityClass);
            methodBuilder.addStatement("$L.set($L, $L,  $T.$L)", new Object[]{childHelper, valueName, udtValueName, NullSavingStrategy.class, NullSavingStrategy.DO_NOT_SET}).addStatement("$1L = $1L.setUdtValue($2L, $3L)", new Object[]{targetName, cqlName, udtValueName}).nextControlFlow("else if ($L == $T.$L)", new Object[]{NULL_SAVING_STRATEGY, NullSavingStrategy.class, NullSavingStrategy.SET_TO_NULL}).addStatement("$1L = $1L.setUdtValue($2L, null)", new Object[]{targetName, cqlName}).endControlFlow();
        } else {
            String mappedCollectionName = enclosingClass.getNameIndex().uniqueField("mappedCollection");
            String rawCollectionName = enclosingClass.getNameIndex().uniqueField("rawCollection");
            methodBuilder.addStatement("$T $L = $L", new Object[]{type.asTypeName(), mappedCollectionName, valueExtractor}).beginControlFlow("if ($L != null)", new Object[]{mappedCollectionName});
            CodeBlock currentCqlType = CodeBlock.of((String)"$L.getType($L)", (Object[])new Object[]{targetName, cqlName});
            CodeBlock.Builder udtTypesBuilder = CodeBlock.builder();
            CodeBlock.Builder conversionCodeBuilder = CodeBlock.builder();
            GeneratedCodePatterns.convertEntitiesIntoUdts(mappedCollectionName, rawCollectionName, type, currentCqlType, udtTypesBuilder, conversionCodeBuilder, enclosingClass);
            methodBuilder.add(udtTypesBuilder.build()).add(conversionCodeBuilder.build()).addStatement("$1L = $1L.set($2L, $3L, $4L)", new Object[]{targetName, cqlName, rawCollectionName, enclosingClass.addGenericTypeConstant(type.asRawTypeName())}).nextControlFlow("else if ($L == $T.$L)", new Object[]{NULL_SAVING_STRATEGY, NullSavingStrategy.class, NullSavingStrategy.SET_TO_NULL}).addStatement("$1L = $1L.set($2L, null, $3L)", new Object[]{targetName, cqlName, enclosingClass.addGenericTypeConstant(type.asRawTypeName())}).endControlFlow();
        }
    }

    private static void generateParameterizedSet(CodeBlock cqlName, CodeBlock valueExtractor, String targetName, CodeBlock.Builder methodBuilder, TypeName typeName, BindableHandlingSharedCode enclosingClass, boolean useNullSavingStrategy) {
        GeneratedCodePatterns.generateSetWithNullSavingStrategy(valueExtractor, methodBuilder, CodeBlock.of((String)"$1L = $1L.set($2L, $3L, $4L)", (Object[])new Object[]{targetName, cqlName, valueExtractor, enclosingClass.addGenericTypeConstant(typeName)}), useNullSavingStrategy);
    }

    private static void generateSetWithClass(CodeBlock cqlName, CodeBlock valueExtractor, String targetName, CodeBlock.Builder methodBuilder, TypeName typeName, boolean useNullSavingStrategy) {
        GeneratedCodePatterns.generateSetWithNullSavingStrategy(valueExtractor, methodBuilder, CodeBlock.of((String)"$1L = $1L.set($2L, $3L, $4T.class)", (Object[])new Object[]{targetName, cqlName, valueExtractor, typeName}), useNullSavingStrategy);
    }

    private static void generateSetWithNullSavingStrategy(CodeBlock valueExtractor, CodeBlock.Builder methodBuilder, CodeBlock nonNullStatement, boolean useNullSavingStrategy) {
        if (useNullSavingStrategy) {
            methodBuilder.beginControlFlow("if ($1L != null || $2L == $3T.$4L)", new Object[]{valueExtractor, NULL_SAVING_STRATEGY, NullSavingStrategy.class, NullSavingStrategy.SET_TO_NULL});
            methodBuilder.addStatement(nonNullStatement);
            methodBuilder.endControlFlow();
        } else {
            methodBuilder.addStatement(nonNullStatement);
        }
    }

    public static void setValue(String cqlName, PropertyType type, CodeBlock valueExtractor, String targetName, CodeBlock.Builder methodBuilder, BindableHandlingSharedCode enclosingClass, boolean useNullSavingStrategy) {
        GeneratedCodePatterns.setValue(CodeBlock.of((String)"$S", (Object[])new Object[]{cqlName}), type, valueExtractor, targetName, methodBuilder, enclosingClass, useNullSavingStrategy);
    }

    private static void convertEntitiesIntoUdts(String mappedObjectName, String rawObjectName, PropertyType type, CodeBlock currentCqlType, CodeBlock.Builder udtTypesBuilder, CodeBlock.Builder conversionBuilder, BindableHandlingSharedCode enclosingClass) {
        if (type instanceof PropertyType.SingleEntity) {
            ClassName entityClass = ((PropertyType.SingleEntity)type).entityName;
            String udtTypeName = enclosingClass.getNameIndex().uniqueField(Introspector.decapitalize(entityClass.simpleName()) + "UdtType");
            udtTypesBuilder.addStatement("$1T $2L = ($1T) $3L", new Object[]{UserDefinedType.class, udtTypeName, currentCqlType});
            String entityHelperName = enclosingClass.addEntityHelperField(entityClass);
            conversionBuilder.addStatement("$T $L = $L.newValue()", new Object[]{UdtValue.class, rawObjectName, udtTypeName}).addStatement("$L.set($L, $L, $T.$L)", new Object[]{entityHelperName, mappedObjectName, rawObjectName, NullSavingStrategy.class, NullSavingStrategy.DO_NOT_SET});
        } else if (type instanceof PropertyType.EntityList) {
            TypeName rawCollectionType = type.asRawTypeName();
            conversionBuilder.addStatement("$T $L = $T.newArrayListWithExpectedSize($L.size())", new Object[]{rawCollectionType, rawObjectName, Lists.class, mappedObjectName});
            PropertyType mappedElementType = ((PropertyType.EntityList)type).elementType;
            String mappedElementName = enclosingClass.getNameIndex().uniqueField("mappedElement");
            conversionBuilder.beginControlFlow("for ($T $L: $L)", new Object[]{mappedElementType.asTypeName(), mappedElementName, mappedObjectName});
            String rawElementName = enclosingClass.getNameIndex().uniqueField("rawElement");
            GeneratedCodePatterns.convertEntitiesIntoUdts(mappedElementName, rawElementName, mappedElementType, CodeBlock.of((String)"(($T) $L).getElementType()", (Object[])new Object[]{ListType.class, currentCqlType}), udtTypesBuilder, conversionBuilder, enclosingClass);
            conversionBuilder.addStatement("$L.add($L)", new Object[]{rawObjectName, rawElementName}).endControlFlow();
        } else if (type instanceof PropertyType.EntitySet) {
            TypeName rawCollectionType = type.asRawTypeName();
            conversionBuilder.addStatement("$T $L = $T.newLinkedHashSetWithExpectedSize($L.size())", new Object[]{rawCollectionType, rawObjectName, Sets.class, mappedObjectName});
            PropertyType mappedElementType = ((PropertyType.EntitySet)type).elementType;
            String mappedElementName = enclosingClass.getNameIndex().uniqueField("mappedElement");
            conversionBuilder.beginControlFlow("for ($T $L: $L)", new Object[]{mappedElementType.asTypeName(), mappedElementName, mappedObjectName});
            String rawElementName = enclosingClass.getNameIndex().uniqueField("rawElement");
            GeneratedCodePatterns.convertEntitiesIntoUdts(mappedElementName, rawElementName, mappedElementType, CodeBlock.of((String)"(($T) $L).getElementType()", (Object[])new Object[]{SetType.class, currentCqlType}), udtTypesBuilder, conversionBuilder, enclosingClass);
            conversionBuilder.addStatement("$L.add($L)", new Object[]{rawObjectName, rawElementName}).endControlFlow();
        } else if (type instanceof PropertyType.EntityMap) {
            String rawValueName;
            String rawKeyName;
            TypeName rawCollectionType = type.asRawTypeName();
            conversionBuilder.addStatement("$T $L = $T.newLinkedHashMapWithExpectedSize($L.size())", new Object[]{rawCollectionType, rawObjectName, Maps.class, mappedObjectName});
            PropertyType mappedKeyType = ((PropertyType.EntityMap)type).keyType;
            PropertyType mappedValueType = ((PropertyType.EntityMap)type).valueType;
            String mappedEntryName = enclosingClass.getNameIndex().uniqueField("mappedEntry");
            conversionBuilder.beginControlFlow("for ($T $L: $L.entrySet())", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Map.Entry.class), (TypeName[])new TypeName[]{mappedKeyType.asTypeName(), mappedValueType.asTypeName()}), mappedEntryName, mappedObjectName});
            String mappedKeyName = CodeBlock.of((String)"$L.getKey()", (Object[])new Object[]{mappedEntryName}).toString();
            if (mappedKeyType instanceof PropertyType.Simple) {
                rawKeyName = mappedKeyName;
            } else {
                rawKeyName = enclosingClass.getNameIndex().uniqueField("rawKey");
                GeneratedCodePatterns.convertEntitiesIntoUdts(mappedKeyName, rawKeyName, mappedKeyType, CodeBlock.of((String)"(($T) $L).getKeyType()", (Object[])new Object[]{MapType.class, currentCqlType}), udtTypesBuilder, conversionBuilder, enclosingClass);
            }
            String mappedValueName = CodeBlock.of((String)"$L.getValue()", (Object[])new Object[]{mappedEntryName}).toString();
            if (mappedValueType instanceof PropertyType.Simple) {
                rawValueName = mappedValueName;
            } else {
                rawValueName = enclosingClass.getNameIndex().uniqueField("rawValue");
                GeneratedCodePatterns.convertEntitiesIntoUdts(mappedValueName, rawValueName, mappedValueType, CodeBlock.of((String)"(($T) $L).getValueType()", (Object[])new Object[]{MapType.class, currentCqlType}), udtTypesBuilder, conversionBuilder, enclosingClass);
            }
            conversionBuilder.addStatement("$L.put($L, $L)", new Object[]{rawObjectName, rawKeyName, rawValueName}).endControlFlow();
        } else {
            throw new AssertionError((Object)("Unsupported type " + type.asTypeName()));
        }
    }
}

