/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.mapper.MapperContext;
import com.datastax.oss.driver.api.mapper.MapperException;
import com.datastax.oss.driver.api.mapper.entity.naming.NameConverter;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DefaultMapperContext
implements MapperContext {
    private final CqlSession session;
    private final CqlIdentifier keyspaceId;
    private final CqlIdentifier tableId;
    private final ConcurrentMap<Class<? extends NameConverter>, NameConverter> nameConverterCache;
    private final Map<Object, Object> customState;

    public DefaultMapperContext(@NonNull CqlSession session, @Nullable CqlIdentifier keyspaceId, @NonNull Map<Object, Object> customState) {
        this(session, keyspaceId, null, new ConcurrentHashMap<Class<? extends NameConverter>, NameConverter>(), (Map<Object, Object>)NullAllowingImmutableMap.copyOf(customState));
    }

    public DefaultMapperContext(@NonNull CqlSession session, @NonNull Map<Object, Object> customState) {
        this(session, null, customState);
    }

    private DefaultMapperContext(CqlSession session, CqlIdentifier keyspaceId, CqlIdentifier tableId, ConcurrentMap<Class<? extends NameConverter>, NameConverter> nameConverterCache, Map<Object, Object> customState) {
        this.session = session;
        this.keyspaceId = keyspaceId;
        this.tableId = tableId;
        this.nameConverterCache = nameConverterCache;
        this.customState = customState;
    }

    public DefaultMapperContext withKeyspaceAndTable(@Nullable CqlIdentifier newKeyspaceId, @Nullable CqlIdentifier newTableId) {
        return Objects.equals(newKeyspaceId, this.keyspaceId) && Objects.equals(newTableId, this.tableId) ? this : new DefaultMapperContext(this.session, newKeyspaceId, newTableId, this.nameConverterCache, this.customState);
    }

    @Override
    @NonNull
    public CqlSession getSession() {
        return this.session;
    }

    @Override
    @Nullable
    public CqlIdentifier getKeyspaceId() {
        return this.keyspaceId;
    }

    @Override
    @Nullable
    public CqlIdentifier getTableId() {
        return this.tableId;
    }

    @Override
    @NonNull
    public NameConverter getNameConverter(Class<? extends NameConverter> converterClass) {
        return this.nameConverterCache.computeIfAbsent(converterClass, DefaultMapperContext::buildNameConverter);
    }

    @Override
    @NonNull
    public Map<Object, Object> getCustomState() {
        return this.customState;
    }

    private static NameConverter buildNameConverter(Class<? extends NameConverter> converterClass) {
        try {
            return converterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new MapperException(String.format("Error while building an instance of %s. %s implementations must have a public no-arg constructor", converterClass, NameConverter.class.getSimpleName()), e);
        }
    }
}

