/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.entity;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.mapper.MapperContext;
import com.datastax.oss.driver.api.mapper.MapperException;
import com.datastax.oss.driver.api.mapper.annotations.DaoFactory;
import com.datastax.oss.driver.api.mapper.annotations.DaoKeyspace;
import com.datastax.oss.driver.api.mapper.annotations.Entity;
import com.datastax.oss.driver.api.mapper.entity.EntityHelper;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;

public abstract class EntityHelperBase<EntityT>
implements EntityHelper<EntityT> {
    protected final CqlIdentifier keyspaceId;
    protected final CqlIdentifier tableId;
    protected final MapperContext context;

    protected EntityHelperBase(MapperContext context, String defaultTableName) {
        this(context, null, defaultTableName);
    }

    protected EntityHelperBase(MapperContext context, String defaultKeyspaceName, String defaultTableName) {
        this.context = context;
        CqlIdentifier cqlIdentifier = this.tableId = context.getTableId() != null ? context.getTableId() : CqlIdentifier.fromCql((String)defaultTableName);
        this.keyspaceId = context.getKeyspaceId() != null ? context.getKeyspaceId() : (defaultKeyspaceName == null ? null : CqlIdentifier.fromCql((String)defaultKeyspaceName));
    }

    @Override
    @Nullable
    public CqlIdentifier getKeyspaceId() {
        return this.keyspaceId;
    }

    @Override
    @NonNull
    public CqlIdentifier getTableId() {
        return this.tableId;
    }

    protected void throwIfKeyspaceMissing() {
        if (this.getKeyspaceId() == null && !this.context.getSession().getKeyspace().isPresent()) {
            throw new MapperException(String.format("Missing keyspace. Suggestions: use SessionBuilder.withKeyspace() when creating your session, specify a default keyspace on %s with @%s(defaultKeyspace), or use a @%s method with a @%s parameter", this.getEntityClass().getSimpleName(), Entity.class.getSimpleName(), DaoFactory.class.getSimpleName(), DaoKeyspace.class.getSimpleName()));
        }
    }
}

