/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.metrics.microprofile;

import com.datastax.dse.driver.api.core.metrics.DseSessionMetric;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.metrics.DefaultSessionMetric;
import com.datastax.oss.driver.api.core.metrics.SessionMetric;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metrics.MetricId;
import com.datastax.oss.driver.internal.core.metrics.SessionMetricUpdater;
import com.datastax.oss.driver.internal.metrics.microprofile.MicroProfileMetricUpdater;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.MetricRegistry;

@ThreadSafe
public class MicroProfileSessionMetricUpdater
extends MicroProfileMetricUpdater<SessionMetric>
implements SessionMetricUpdater {
    public MicroProfileSessionMetricUpdater(InternalDriverContext context, Set<SessionMetric> enabledMetrics, MetricRegistry registry) {
        super(context, enabledMetrics, registry);
        DriverExecutionProfile profile = context.getConfig().getDefaultProfile();
        this.initializeGauge(DefaultSessionMetric.CONNECTED_NODES, profile, (Gauge<Number>)((Gauge)() -> ((MicroProfileSessionMetricUpdater)this).connectedNodes()));
        this.initializeGauge(DefaultSessionMetric.THROTTLING_QUEUE_SIZE, profile, (Gauge<Number>)((Gauge)() -> ((MicroProfileSessionMetricUpdater)this).throttlingQueueSize()));
        this.initializeGauge(DefaultSessionMetric.CQL_PREPARED_CACHE_SIZE, profile, (Gauge<Number>)((Gauge)() -> ((MicroProfileSessionMetricUpdater)this).preparedStatementCacheSize()));
        this.initializeCounter(DefaultSessionMetric.CQL_CLIENT_TIMEOUTS, profile);
        this.initializeCounter(DefaultSessionMetric.THROTTLING_ERRORS, profile);
        this.initializeCounter(DseSessionMetric.GRAPH_CLIENT_TIMEOUTS, profile);
        this.initializeTimer(DefaultSessionMetric.CQL_REQUESTS, profile);
        this.initializeTimer(DefaultSessionMetric.THROTTLING_DELAY, profile);
        this.initializeTimer(DseSessionMetric.CONTINUOUS_CQL_REQUESTS, profile);
        this.initializeTimer(DseSessionMetric.GRAPH_REQUESTS, profile);
    }

    @Override
    protected MetricId getMetricId(SessionMetric metric) {
        return this.context.getMetricIdGenerator().sessionMetricId(metric);
    }
}

