/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.querybuilder.select;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.querybuilder.QueryBuilderDsl;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.select.Selector;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Arrays;
import java.util.Map;

public interface OngoingSelection {
    @NonNull
    public Select selector(@NonNull Selector var1);

    @NonNull
    public Select selectors(@NonNull Iterable<Selector> var1);

    @NonNull
    default public Select selectors(Selector ... additionalSelectors) {
        return this.selectors(Arrays.asList(additionalSelectors));
    }

    @NonNull
    default public Select all() {
        return this.selector(Selector.all());
    }

    @NonNull
    default public Select countAll() {
        return this.selector(Selector.countAll());
    }

    @NonNull
    default public Select column(@NonNull CqlIdentifier columnId) {
        return this.selector(Selector.column(columnId));
    }

    @NonNull
    default public Select column(@NonNull String columnName) {
        return this.column(CqlIdentifier.fromCql((String)columnName));
    }

    @NonNull
    default public Select columnsIds(@NonNull Iterable<CqlIdentifier> columnIds) {
        return this.selectors(Iterables.transform(columnIds, Selector::column));
    }

    @NonNull
    default public Select columns(CqlIdentifier ... columnIds) {
        return this.columnsIds(Arrays.asList(columnIds));
    }

    @NonNull
    default public Select columns(@NonNull Iterable<String> columnNames) {
        return this.selectors(Iterables.transform(columnNames, Selector::column));
    }

    @NonNull
    default public Select columns(String ... columnNames) {
        return this.columns(Arrays.asList(columnNames));
    }

    @NonNull
    default public Select add(@NonNull Selector left, @NonNull Selector right) {
        return this.selector(Selector.add(left, right));
    }

    @NonNull
    default public Select subtract(@NonNull Selector left, @NonNull Selector right) {
        return this.selector(Selector.subtract(left, right));
    }

    @NonNull
    default public Select multiply(@NonNull Selector left, @NonNull Selector right) {
        return this.selector(Selector.multiply(left, right));
    }

    @NonNull
    default public Select divide(@NonNull Selector left, @NonNull Selector right) {
        return this.selector(Selector.divide(left, right));
    }

    @NonNull
    default public Select remainder(@NonNull Selector left, @NonNull Selector right) {
        return this.selector(Selector.remainder(left, right));
    }

    @NonNull
    default public Select negate(@NonNull Selector argument) {
        return this.selector(Selector.negate(argument));
    }

    @NonNull
    default public Select field(@NonNull Selector udt, @NonNull CqlIdentifier fieldId) {
        return this.selector(Selector.field(udt, fieldId));
    }

    @NonNull
    default public Select field(@NonNull Selector udt, @NonNull String fieldName) {
        return this.field(udt, CqlIdentifier.fromCql((String)fieldName));
    }

    @NonNull
    default public Select field(@NonNull CqlIdentifier udtColumnId, @NonNull CqlIdentifier fieldId) {
        return this.field(Selector.column(udtColumnId), fieldId);
    }

    @NonNull
    default public Select field(@NonNull String udtColumnName, @NonNull String fieldName) {
        return this.field(CqlIdentifier.fromCql((String)udtColumnName), CqlIdentifier.fromCql((String)fieldName));
    }

    @NonNull
    default public Select element(@NonNull Selector collection, @NonNull Term index) {
        return this.selector(Selector.element(collection, index));
    }

    @NonNull
    default public Select element(@NonNull CqlIdentifier collectionId, @NonNull Term index) {
        return this.element(Selector.column(collectionId), index);
    }

    @NonNull
    default public Select element(@NonNull String collectionName, @NonNull Term index) {
        return this.element(CqlIdentifier.fromCql((String)collectionName), index);
    }

    @NonNull
    default public Select range(@NonNull Selector collection, @NonNull Term left, @NonNull Term right) {
        return this.selector(Selector.range(collection, left, right));
    }

    @NonNull
    default public Select range(@NonNull CqlIdentifier collectionId, @NonNull Term left, @NonNull Term right) {
        return this.range(Selector.column(collectionId), left, right);
    }

    @NonNull
    default public Select range(@NonNull String collectionName, @NonNull Term left, @NonNull Term right) {
        return this.range(CqlIdentifier.fromCql((String)collectionName), left, right);
    }

    @NonNull
    default public Select listOf(@NonNull Iterable<Selector> elementSelectors) {
        return this.selector(Selector.listOf(elementSelectors));
    }

    @NonNull
    default public Select listOf(Selector ... elementSelectors) {
        return this.listOf(Arrays.asList(elementSelectors));
    }

    @NonNull
    default public Select setOf(@NonNull Iterable<Selector> elementSelectors) {
        return this.selector(Selector.setOf(elementSelectors));
    }

    @NonNull
    default public Select setOf(Selector ... elementSelectors) {
        return this.setOf(Arrays.asList(elementSelectors));
    }

    @NonNull
    default public Select tupleOf(@NonNull Iterable<Selector> elementSelectors) {
        return this.selector(Selector.tupleOf(elementSelectors));
    }

    @NonNull
    default public Select tupleOf(Selector ... elementSelectors) {
        return this.tupleOf(Arrays.asList(elementSelectors));
    }

    @NonNull
    default public Select mapOf(@NonNull Map<Selector, Selector> elementSelectors) {
        return this.selector(Selector.mapOf(elementSelectors));
    }

    @NonNull
    default public Select mapOf(@NonNull Map<Selector, Selector> elementSelectors, @NonNull DataType keyType, @NonNull DataType valueType) {
        return this.selector(Selector.mapOf(elementSelectors, keyType, valueType));
    }

    @NonNull
    default public Select typeHint(@NonNull Selector selector, @NonNull DataType targetType) {
        return this.selector(Selector.typeHint(selector, targetType));
    }

    @NonNull
    default public Select function(@NonNull CqlIdentifier functionId, @NonNull Iterable<Selector> arguments) {
        return this.selector(Selector.function(functionId, arguments));
    }

    @NonNull
    default public Select function(@NonNull CqlIdentifier functionId, Selector ... arguments) {
        return this.function(functionId, Arrays.asList(arguments));
    }

    @NonNull
    default public Select function(@NonNull String functionName, @NonNull Iterable<Selector> arguments) {
        return this.function(CqlIdentifier.fromCql((String)functionName), arguments);
    }

    @NonNull
    default public Select function(@NonNull String functionName, Selector ... arguments) {
        return this.function(functionName, Arrays.asList(arguments));
    }

    @NonNull
    default public Select function(@Nullable CqlIdentifier keyspaceId, @NonNull CqlIdentifier functionId, @NonNull Iterable<Selector> arguments) {
        return this.selector(Selector.function(keyspaceId, functionId, arguments));
    }

    @NonNull
    default public Select function(@Nullable CqlIdentifier keyspaceId, @NonNull CqlIdentifier functionId, Selector ... arguments) {
        return this.function(keyspaceId, functionId, Arrays.asList(arguments));
    }

    @NonNull
    default public Select function(@Nullable String keyspaceName, @NonNull String functionName, @NonNull Iterable<Selector> arguments) {
        return this.function(keyspaceName == null ? null : CqlIdentifier.fromCql((String)keyspaceName), CqlIdentifier.fromCql((String)functionName), arguments);
    }

    @NonNull
    default public Select function(@Nullable String keyspaceName, @NonNull String functionName, Selector ... arguments) {
        return this.function(keyspaceName, functionName, Arrays.asList(arguments));
    }

    @NonNull
    default public Select writeTime(@NonNull CqlIdentifier columnId) {
        return this.selector(Selector.writeTime(columnId));
    }

    @NonNull
    default public Select writeTime(@NonNull String columnName) {
        return this.writeTime(CqlIdentifier.fromCql((String)columnName));
    }

    @NonNull
    default public Select ttl(@NonNull CqlIdentifier columnId) {
        return this.selector(Selector.ttl(columnId));
    }

    @NonNull
    default public Select ttl(@NonNull String columnName) {
        return this.ttl(CqlIdentifier.fromCql((String)columnName));
    }

    @NonNull
    default public Select cast(@NonNull Selector selector, @NonNull DataType targetType) {
        return this.selector(Selector.cast(selector, targetType));
    }

    @NonNull
    default public Select toDate(@NonNull CqlIdentifier columnId) {
        return this.selector(Selector.toDate(columnId));
    }

    @NonNull
    default public Select toDate(@NonNull String columnName) {
        return this.toDate(CqlIdentifier.fromCql((String)columnName));
    }

    @NonNull
    default public Select toTimestamp(@NonNull CqlIdentifier columnId) {
        return this.selector(Selector.toTimestamp(columnId));
    }

    @NonNull
    default public Select toTimestamp(@NonNull String columnName) {
        return this.toTimestamp(CqlIdentifier.fromCql((String)columnName));
    }

    @NonNull
    default public Select toUnixTimestamp(@NonNull CqlIdentifier columnId) {
        return this.selector(Selector.toUnixTimestamp(columnId));
    }

    @NonNull
    default public Select toUnixTimestamp(@NonNull String columnName) {
        return this.toUnixTimestamp(CqlIdentifier.fromCql((String)columnName));
    }

    @NonNull
    default public Select literal(@Nullable Object value) {
        return this.literal(value, CodecRegistry.DEFAULT);
    }

    @NonNull
    default public Select literal(@Nullable Object value, @NonNull CodecRegistry codecRegistry) {
        return this.literal(value, value == null ? null : codecRegistry.codecFor(value));
    }

    @NonNull
    default public <T> Select literal(@Nullable T value, @Nullable TypeCodec<T> codec) {
        return this.selector(QueryBuilderDsl.literal(value, codec));
    }

    @NonNull
    default public Select raw(@NonNull String rawExpression) {
        return this.selector(QueryBuilderDsl.raw(rawExpression));
    }

    @NonNull
    public Select as(@NonNull CqlIdentifier var1);

    @NonNull
    default public Select as(@NonNull String alias) {
        return this.as(CqlIdentifier.fromCql((String)alias));
    }
}

