/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.querybuilder.select;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.querybuilder.CqlSnippet;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.internal.querybuilder.ArithmeticOperator;
import com.datastax.oss.driver.internal.querybuilder.select.AllSelector;
import com.datastax.oss.driver.internal.querybuilder.select.BinaryArithmeticSelector;
import com.datastax.oss.driver.internal.querybuilder.select.CastSelector;
import com.datastax.oss.driver.internal.querybuilder.select.ColumnSelector;
import com.datastax.oss.driver.internal.querybuilder.select.CountAllSelector;
import com.datastax.oss.driver.internal.querybuilder.select.ElementSelector;
import com.datastax.oss.driver.internal.querybuilder.select.FieldSelector;
import com.datastax.oss.driver.internal.querybuilder.select.FunctionSelector;
import com.datastax.oss.driver.internal.querybuilder.select.ListSelector;
import com.datastax.oss.driver.internal.querybuilder.select.MapSelector;
import com.datastax.oss.driver.internal.querybuilder.select.OppositeSelector;
import com.datastax.oss.driver.internal.querybuilder.select.RangeSelector;
import com.datastax.oss.driver.internal.querybuilder.select.SetSelector;
import com.datastax.oss.driver.internal.querybuilder.select.TupleSelector;
import com.datastax.oss.driver.internal.querybuilder.select.TypeHintSelector;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Arrays;
import java.util.Map;

public interface Selector
extends CqlSnippet {
    @NonNull
    public static Selector all() {
        return AllSelector.INSTANCE;
    }

    @NonNull
    public static Selector countAll() {
        return new CountAllSelector();
    }

    @NonNull
    public static Selector column(@NonNull CqlIdentifier columnId) {
        return new ColumnSelector(columnId);
    }

    @NonNull
    public static Selector column(@NonNull String columnName) {
        return Selector.column(CqlIdentifier.fromCql((String)columnName));
    }

    @NonNull
    public static Selector add(@NonNull Selector left, @NonNull Selector right) {
        return new BinaryArithmeticSelector(ArithmeticOperator.SUM, left, right);
    }

    @NonNull
    public static Selector subtract(@NonNull Selector left, @NonNull Selector right) {
        return new BinaryArithmeticSelector(ArithmeticOperator.DIFFERENCE, left, right);
    }

    @NonNull
    public static Selector multiply(@NonNull Selector left, @NonNull Selector right) {
        return new BinaryArithmeticSelector(ArithmeticOperator.PRODUCT, left, right);
    }

    @NonNull
    public static Selector divide(@NonNull Selector left, @NonNull Selector right) {
        return new BinaryArithmeticSelector(ArithmeticOperator.QUOTIENT, left, right);
    }

    @NonNull
    public static Selector remainder(@NonNull Selector left, @NonNull Selector right) {
        return new BinaryArithmeticSelector(ArithmeticOperator.REMAINDER, left, right);
    }

    @NonNull
    public static Selector negate(@NonNull Selector argument) {
        return new OppositeSelector(argument);
    }

    @NonNull
    public static Selector field(@NonNull Selector udt, @NonNull CqlIdentifier fieldId) {
        return new FieldSelector(udt, fieldId);
    }

    @NonNull
    public static Selector field(@NonNull Selector udt, @NonNull String fieldName) {
        return Selector.field(udt, CqlIdentifier.fromCql((String)fieldName));
    }

    @NonNull
    public static Selector field(@NonNull CqlIdentifier udtColumnId, @NonNull CqlIdentifier fieldId) {
        return Selector.field(Selector.column(udtColumnId), fieldId);
    }

    @NonNull
    public static Selector field(@NonNull String udtColumnName, @NonNull String fieldName) {
        return Selector.field(CqlIdentifier.fromCql((String)udtColumnName), CqlIdentifier.fromCql((String)fieldName));
    }

    @NonNull
    public static Selector element(@NonNull Selector collection, @NonNull Term index) {
        return new ElementSelector(collection, index);
    }

    @NonNull
    public static Selector element(@NonNull CqlIdentifier collectionId, @NonNull Term index) {
        return Selector.element(Selector.column(collectionId), index);
    }

    @NonNull
    public static Selector element(@NonNull String collectionName, @NonNull Term index) {
        return Selector.element(CqlIdentifier.fromCql((String)collectionName), index);
    }

    @NonNull
    public static Selector range(@NonNull Selector collection, @NonNull Term left, @NonNull Term right) {
        return new RangeSelector(collection, left, right);
    }

    @NonNull
    public static Selector range(@NonNull CqlIdentifier collectionId, @NonNull Term left, @NonNull Term right) {
        return Selector.range(Selector.column(collectionId), left, right);
    }

    @NonNull
    public static Selector range(@NonNull String collectionName, @NonNull Term left, @NonNull Term right) {
        return Selector.range(CqlIdentifier.fromCql((String)collectionName), left, right);
    }

    @NonNull
    public static Selector listOf(@NonNull Iterable<Selector> elementSelectors) {
        return new ListSelector(elementSelectors);
    }

    @NonNull
    public static Selector listOf(Selector ... elementSelectors) {
        return Selector.listOf(Arrays.asList(elementSelectors));
    }

    @NonNull
    public static Selector setOf(@NonNull Iterable<Selector> elementSelectors) {
        return new SetSelector(elementSelectors);
    }

    @NonNull
    public static Selector setOf(Selector ... elementSelectors) {
        return Selector.setOf(Arrays.asList(elementSelectors));
    }

    @NonNull
    public static Selector tupleOf(@NonNull Iterable<Selector> elementSelectors) {
        return new TupleSelector(elementSelectors);
    }

    @NonNull
    public static Selector tupleOf(Selector ... elementSelectors) {
        return Selector.tupleOf(Arrays.asList(elementSelectors));
    }

    @NonNull
    public static Selector mapOf(@NonNull Map<Selector, Selector> elementSelectors) {
        return Selector.mapOf(elementSelectors, null, null);
    }

    @NonNull
    public static Selector mapOf(@NonNull Map<Selector, Selector> elementSelectors, @Nullable DataType keyType, @Nullable DataType valueType) {
        return new MapSelector(elementSelectors, keyType, valueType);
    }

    @NonNull
    public static Selector typeHint(@NonNull Selector selector, @NonNull DataType targetType) {
        return new TypeHintSelector(selector, targetType);
    }

    @NonNull
    public static Selector function(@NonNull CqlIdentifier functionId, @NonNull Iterable<Selector> arguments) {
        return new FunctionSelector(null, functionId, arguments);
    }

    @NonNull
    public static Selector function(@NonNull CqlIdentifier functionId, Selector ... arguments) {
        return Selector.function(functionId, Arrays.asList(arguments));
    }

    @NonNull
    public static Selector function(@NonNull String functionName, @NonNull Iterable<Selector> arguments) {
        return Selector.function(CqlIdentifier.fromCql((String)functionName), arguments);
    }

    @NonNull
    public static Selector function(@NonNull String functionName, Selector ... arguments) {
        return Selector.function(functionName, Arrays.asList(arguments));
    }

    @NonNull
    public static Selector function(@Nullable CqlIdentifier keyspaceId, @NonNull CqlIdentifier functionId, @NonNull Iterable<Selector> arguments) {
        return new FunctionSelector(keyspaceId, functionId, arguments);
    }

    @NonNull
    public static Selector function(@Nullable CqlIdentifier keyspaceId, @NonNull CqlIdentifier functionId, Selector ... arguments) {
        return Selector.function(keyspaceId, functionId, Arrays.asList(arguments));
    }

    @NonNull
    public static Selector function(@Nullable String keyspaceName, @NonNull String functionName, @NonNull Iterable<Selector> arguments) {
        return Selector.function(keyspaceName == null ? null : CqlIdentifier.fromCql((String)keyspaceName), CqlIdentifier.fromCql((String)functionName), arguments);
    }

    @NonNull
    public static Selector function(@Nullable String keyspaceName, @NonNull String functionName, Selector ... arguments) {
        return Selector.function(keyspaceName, functionName, Arrays.asList(arguments));
    }

    @NonNull
    public static Selector writeTime(@NonNull CqlIdentifier columnId) {
        return Selector.function("writetime", Selector.column(columnId));
    }

    @NonNull
    public static Selector writeTime(@NonNull String columnName) {
        return Selector.writeTime(CqlIdentifier.fromCql((String)columnName));
    }

    @NonNull
    public static Selector ttl(@NonNull CqlIdentifier columnId) {
        return Selector.function("ttl", Selector.column(columnId));
    }

    @NonNull
    public static Selector ttl(@NonNull String columnName) {
        return Selector.ttl(CqlIdentifier.fromCql((String)columnName));
    }

    @NonNull
    public static Selector cast(@NonNull Selector selector, @NonNull DataType targetType) {
        return new CastSelector(selector, targetType);
    }

    @NonNull
    public static Selector toDate(@NonNull CqlIdentifier columnId) {
        return Selector.function("todate", Selector.column(columnId));
    }

    @NonNull
    public static Selector toDate(@NonNull String columnName) {
        return Selector.toDate(CqlIdentifier.fromCql((String)columnName));
    }

    @NonNull
    public static Selector toTimestamp(@NonNull CqlIdentifier columnId) {
        return Selector.function("totimestamp", Selector.column(columnId));
    }

    @NonNull
    public static Selector toTimestamp(@NonNull String columnName) {
        return Selector.toTimestamp(CqlIdentifier.fromCql((String)columnName));
    }

    @NonNull
    public static Selector toUnixTimestamp(@NonNull CqlIdentifier columnId) {
        return Selector.function("tounixtimestamp", Selector.column(columnId));
    }

    @NonNull
    public static Selector toUnixTimestamp(@NonNull String columnName) {
        return Selector.toUnixTimestamp(CqlIdentifier.fromCql((String)columnName));
    }

    @NonNull
    public Selector as(@NonNull CqlIdentifier var1);

    @NonNull
    default public Selector as(@NonNull String alias) {
        return this.as(CqlIdentifier.fromCql((String)alias));
    }

    @Nullable
    public CqlIdentifier getAlias();
}

