/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.insert;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatementBuilder;
import com.datastax.oss.driver.api.querybuilder.BindMarker;
import com.datastax.oss.driver.api.querybuilder.CqlSnippet;
import com.datastax.oss.driver.api.querybuilder.QueryBuilderDsl;
import com.datastax.oss.driver.api.querybuilder.insert.Insert;
import com.datastax.oss.driver.api.querybuilder.insert.InsertInto;
import com.datastax.oss.driver.api.querybuilder.insert.JsonInsert;
import com.datastax.oss.driver.api.querybuilder.insert.RegularInsert;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.internal.querybuilder.CqlHelper;
import com.datastax.oss.driver.internal.querybuilder.ImmutableCollections;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultInsert
implements InsertInto,
RegularInsert,
JsonInsert {
    private final CqlIdentifier keyspace;
    private final CqlIdentifier table;
    private final Term json;
    private final MissingJsonBehavior missingJsonBehavior;
    private final ImmutableMap<CqlIdentifier, Term> assignments;
    private final Object timestamp;
    private final boolean ifNotExists;

    public DefaultInsert(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier table) {
        this(keyspace, table, null, null, (ImmutableMap<CqlIdentifier, Term>)ImmutableMap.of(), null, false);
    }

    public DefaultInsert(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier table, @Nullable Term json, @Nullable MissingJsonBehavior missingJsonBehavior, @NonNull ImmutableMap<CqlIdentifier, Term> assignments, @Nullable Object timestamp, boolean ifNotExists) {
        Preconditions.checkArgument((json == null || assignments.isEmpty() ? 1 : 0) != 0, (Object)"JSON insert can't have regular assignments");
        this.keyspace = keyspace;
        this.table = table;
        this.json = json;
        this.missingJsonBehavior = missingJsonBehavior;
        this.assignments = assignments;
        this.timestamp = timestamp;
        this.ifNotExists = ifNotExists;
    }

    @Override
    @NonNull
    public JsonInsert json(@NonNull String json) {
        return new DefaultInsert(this.keyspace, this.table, QueryBuilderDsl.literal(json), this.missingJsonBehavior, (ImmutableMap<CqlIdentifier, Term>)ImmutableMap.of(), this.timestamp, this.ifNotExists);
    }

    @Override
    @NonNull
    public JsonInsert json(@NonNull BindMarker json) {
        return new DefaultInsert(this.keyspace, this.table, json, this.missingJsonBehavior, (ImmutableMap<CqlIdentifier, Term>)ImmutableMap.of(), this.timestamp, this.ifNotExists);
    }

    @Override
    @NonNull
    public JsonInsert defaultNull() {
        return new DefaultInsert(this.keyspace, this.table, this.json, MissingJsonBehavior.NULL, (ImmutableMap<CqlIdentifier, Term>)ImmutableMap.of(), this.timestamp, this.ifNotExists);
    }

    @Override
    @NonNull
    public JsonInsert defaultUnset() {
        return new DefaultInsert(this.keyspace, this.table, this.json, MissingJsonBehavior.UNSET, (ImmutableMap<CqlIdentifier, Term>)ImmutableMap.of(), this.timestamp, this.ifNotExists);
    }

    @Override
    @NonNull
    public RegularInsert value(@NonNull CqlIdentifier columnId, @NonNull Term value) {
        return new DefaultInsert(this.keyspace, this.table, null, null, ImmutableCollections.append(this.assignments, columnId, value), this.timestamp, this.ifNotExists);
    }

    @Override
    @NonNull
    public Insert ifNotExists() {
        return new DefaultInsert(this.keyspace, this.table, this.json, this.missingJsonBehavior, this.assignments, this.timestamp, true);
    }

    @Override
    @NonNull
    public Insert usingTimestamp(long timestamp) {
        return new DefaultInsert(this.keyspace, this.table, this.json, this.missingJsonBehavior, this.assignments, timestamp, this.ifNotExists);
    }

    @Override
    @NonNull
    public Insert usingTimestamp(@Nullable BindMarker timestamp) {
        return new DefaultInsert(this.keyspace, this.table, this.json, this.missingJsonBehavior, this.assignments, timestamp, this.ifNotExists);
    }

    @Override
    @NonNull
    public String asCql() {
        StringBuilder builder = new StringBuilder("INSERT INTO ");
        CqlHelper.qualify(this.keyspace, this.table, builder);
        if (this.json == null) {
            CqlHelper.appendIds((Iterable<CqlIdentifier>)this.assignments.keySet(), builder, " (", ",", ")");
            CqlHelper.append((Iterable<? extends CqlSnippet>)this.assignments.values(), builder, " VALUES (", ",", ")");
        } else {
            builder.append(" JSON ");
            this.json.appendTo(builder);
            if (this.missingJsonBehavior == MissingJsonBehavior.NULL) {
                builder.append(" DEFAULT NULL");
            } else if (this.missingJsonBehavior == MissingJsonBehavior.UNSET) {
                builder.append(" DEFAULT UNSET");
            }
        }
        if (this.ifNotExists) {
            builder.append(" IF NOT EXISTS");
        }
        if (this.timestamp != null) {
            builder.append(" USING TIMESTAMP ");
            if (this.timestamp instanceof BindMarker) {
                ((BindMarker)this.timestamp).appendTo(builder);
            } else {
                builder.append(this.timestamp);
            }
        }
        return builder.toString();
    }

    @Override
    @NonNull
    public SimpleStatement build() {
        return this.builder().build();
    }

    @Override
    @NonNull
    public SimpleStatementBuilder builder() {
        return (SimpleStatementBuilder)SimpleStatement.builder((String)this.asCql()).withIdempotence(Boolean.valueOf(this.isIdempotent()));
    }

    public boolean isIdempotent() {
        if (this.ifNotExists) {
            return false;
        }
        for (Term value : this.assignments.values()) {
            if (value.isIdempotent()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public CqlIdentifier getKeyspace() {
        return this.keyspace;
    }

    @NonNull
    public CqlIdentifier getTable() {
        return this.table;
    }

    @Nullable
    public Object getJson() {
        return this.json;
    }

    @Nullable
    public MissingJsonBehavior getMissingJsonBehavior() {
        return this.missingJsonBehavior;
    }

    @NonNull
    public ImmutableMap<CqlIdentifier, Term> getAssignments() {
        return this.assignments;
    }

    @Nullable
    public Object getTimestamp() {
        return this.timestamp;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public String toString() {
        return this.asCql();
    }

    public static enum MissingJsonBehavior {
        NULL,
        UNSET;

    }
}

