/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.querybuilder.update;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.CqlSnippet;
import com.datastax.oss.driver.api.querybuilder.QueryBuilderDsl;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.internal.querybuilder.lhs.ColumnComponentLeftOperand;
import com.datastax.oss.driver.internal.querybuilder.lhs.ColumnLeftOperand;
import com.datastax.oss.driver.internal.querybuilder.lhs.FieldLeftOperand;
import com.datastax.oss.driver.internal.querybuilder.update.AppendAssignment;
import com.datastax.oss.driver.internal.querybuilder.update.AppendListElementAssignment;
import com.datastax.oss.driver.internal.querybuilder.update.AppendMapEntryAssignment;
import com.datastax.oss.driver.internal.querybuilder.update.AppendSetElementAssignment;
import com.datastax.oss.driver.internal.querybuilder.update.CounterAssignment;
import com.datastax.oss.driver.internal.querybuilder.update.DefaultAssignment;
import com.datastax.oss.driver.internal.querybuilder.update.PrependAssignment;
import com.datastax.oss.driver.internal.querybuilder.update.PrependListElementAssignment;
import com.datastax.oss.driver.internal.querybuilder.update.PrependMapEntryAssignment;
import com.datastax.oss.driver.internal.querybuilder.update.PrependSetElementAssignment;
import com.datastax.oss.driver.internal.querybuilder.update.RemoveListElementAssignment;
import com.datastax.oss.driver.internal.querybuilder.update.RemoveMapEntryAssignment;
import com.datastax.oss.driver.internal.querybuilder.update.RemoveSetElementAssignment;
import edu.umd.cs.findbugs.annotations.NonNull;

public interface Assignment
extends CqlSnippet {
    @NonNull
    public static Assignment setColumn(@NonNull CqlIdentifier columnId, @NonNull Term value) {
        return new DefaultAssignment(new ColumnLeftOperand(columnId), "=", value);
    }

    @NonNull
    public static Assignment setColumn(@NonNull String columnName, @NonNull Term value) {
        return Assignment.setColumn(CqlIdentifier.fromCql((String)columnName), value);
    }

    @NonNull
    public static Assignment setField(@NonNull CqlIdentifier columnId, @NonNull CqlIdentifier fieldId, @NonNull Term value) {
        return new DefaultAssignment(new FieldLeftOperand(columnId, fieldId), "=", value);
    }

    @NonNull
    public static Assignment setField(@NonNull String columnName, @NonNull String fieldName, @NonNull Term value) {
        return Assignment.setField(CqlIdentifier.fromCql((String)columnName), CqlIdentifier.fromCql((String)fieldName), value);
    }

    @NonNull
    public static Assignment setMapValue(@NonNull CqlIdentifier columnId, @NonNull Term index, @NonNull Term value) {
        return new DefaultAssignment(new ColumnComponentLeftOperand(columnId, index), "=", value);
    }

    @NonNull
    public static Assignment setMapValue(@NonNull String columnName, @NonNull Term index, @NonNull Term value) {
        return Assignment.setMapValue(CqlIdentifier.fromCql((String)columnName), index, value);
    }

    @NonNull
    public static Assignment increment(@NonNull CqlIdentifier columnId, @NonNull Term amount) {
        return new CounterAssignment(new ColumnLeftOperand(columnId), "+=", amount);
    }

    @NonNull
    public static Assignment increment(@NonNull String columnName, @NonNull Term amount) {
        return Assignment.increment(CqlIdentifier.fromCql((String)columnName), amount);
    }

    @NonNull
    public static Assignment increment(@NonNull CqlIdentifier columnId) {
        return Assignment.increment(columnId, (Term)QueryBuilderDsl.literal(1));
    }

    @NonNull
    public static Assignment increment(@NonNull String columnName) {
        return Assignment.increment(CqlIdentifier.fromCql((String)columnName));
    }

    @NonNull
    public static Assignment decrement(@NonNull CqlIdentifier columnId, @NonNull Term amount) {
        return new CounterAssignment(new ColumnLeftOperand(columnId), "-=", amount);
    }

    @NonNull
    public static Assignment decrement(@NonNull String columnName, @NonNull Term amount) {
        return Assignment.decrement(CqlIdentifier.fromCql((String)columnName), amount);
    }

    @NonNull
    public static Assignment decrement(@NonNull CqlIdentifier columnId) {
        return Assignment.decrement(columnId, (Term)QueryBuilderDsl.literal(1));
    }

    @NonNull
    public static Assignment decrement(@NonNull String columnName) {
        return Assignment.decrement(CqlIdentifier.fromCql((String)columnName));
    }

    @NonNull
    public static Assignment append(@NonNull CqlIdentifier columnId, @NonNull Term suffix) {
        return new AppendAssignment(new ColumnLeftOperand(columnId), suffix);
    }

    @NonNull
    public static Assignment append(@NonNull String columnName, @NonNull Term suffix) {
        return Assignment.append(CqlIdentifier.fromCql((String)columnName), suffix);
    }

    @NonNull
    public static Assignment appendListElement(@NonNull CqlIdentifier columnId, @NonNull Term suffix) {
        return new AppendListElementAssignment(columnId, suffix);
    }

    @NonNull
    public static Assignment appendListElement(@NonNull String columnName, @NonNull Term suffix) {
        return Assignment.appendListElement(CqlIdentifier.fromCql((String)columnName), suffix);
    }

    @NonNull
    public static Assignment appendSetElement(@NonNull CqlIdentifier columnId, @NonNull Term suffix) {
        return new AppendSetElementAssignment(columnId, suffix);
    }

    @NonNull
    public static Assignment appendSetElement(@NonNull String columnName, @NonNull Term suffix) {
        return Assignment.appendSetElement(CqlIdentifier.fromCql((String)columnName), suffix);
    }

    @NonNull
    public static Assignment appendMapEntry(@NonNull CqlIdentifier columnId, @NonNull Term key, @NonNull Term value) {
        return new AppendMapEntryAssignment(columnId, key, value);
    }

    @NonNull
    public static Assignment appendMapEntry(@NonNull String columnName, @NonNull Term key, @NonNull Term value) {
        return Assignment.appendMapEntry(CqlIdentifier.fromCql((String)columnName), key, value);
    }

    @NonNull
    public static Assignment prepend(@NonNull CqlIdentifier columnId, @NonNull Term prefix) {
        return new PrependAssignment(columnId, prefix);
    }

    @NonNull
    public static Assignment prepend(@NonNull String columnName, @NonNull Term prefix) {
        return Assignment.prepend(CqlIdentifier.fromCql((String)columnName), prefix);
    }

    @NonNull
    public static Assignment prependListElement(@NonNull CqlIdentifier columnId, @NonNull Term suffix) {
        return new PrependListElementAssignment(columnId, suffix);
    }

    @NonNull
    public static Assignment prependListElement(@NonNull String columnName, @NonNull Term suffix) {
        return Assignment.prependListElement(CqlIdentifier.fromCql((String)columnName), suffix);
    }

    @NonNull
    public static Assignment prependSetElement(@NonNull CqlIdentifier columnId, @NonNull Term suffix) {
        return new PrependSetElementAssignment(columnId, suffix);
    }

    @NonNull
    public static Assignment prependSetElement(@NonNull String columnName, @NonNull Term suffix) {
        return Assignment.prependSetElement(CqlIdentifier.fromCql((String)columnName), suffix);
    }

    @NonNull
    public static Assignment prependMapEntry(@NonNull CqlIdentifier columnId, @NonNull Term key, @NonNull Term value) {
        return new PrependMapEntryAssignment(columnId, key, value);
    }

    @NonNull
    public static Assignment prependMapEntry(@NonNull String columnName, @NonNull Term key, @NonNull Term value) {
        return Assignment.prependMapEntry(CqlIdentifier.fromCql((String)columnName), key, value);
    }

    @NonNull
    public static Assignment remove(@NonNull CqlIdentifier columnId, @NonNull Term collectionToRemove) {
        return new DefaultAssignment(new ColumnLeftOperand(columnId), "-=", collectionToRemove);
    }

    @NonNull
    public static Assignment remove(@NonNull String columnName, @NonNull Term collectionToRemove) {
        return Assignment.remove(CqlIdentifier.fromCql((String)columnName), collectionToRemove);
    }

    @NonNull
    public static Assignment removeListElement(@NonNull CqlIdentifier columnId, @NonNull Term suffix) {
        return new RemoveListElementAssignment(columnId, suffix);
    }

    @NonNull
    public static Assignment removeListElement(@NonNull String columnName, @NonNull Term suffix) {
        return Assignment.removeListElement(CqlIdentifier.fromCql((String)columnName), suffix);
    }

    @NonNull
    public static Assignment removeSetElement(@NonNull CqlIdentifier columnId, @NonNull Term suffix) {
        return new RemoveSetElementAssignment(columnId, suffix);
    }

    @NonNull
    public static Assignment removeSetElement(@NonNull String columnName, @NonNull Term suffix) {
        return Assignment.removeSetElement(CqlIdentifier.fromCql((String)columnName), suffix);
    }

    @NonNull
    public static Assignment removeMapEntry(@NonNull CqlIdentifier columnId, @NonNull Term key, @NonNull Term value) {
        return new RemoveMapEntryAssignment(columnId, key, value);
    }

    @NonNull
    public static Assignment removeMapEntry(@NonNull String columnName, @NonNull Term key, @NonNull Term value) {
        return Assignment.removeMapEntry(CqlIdentifier.fromCql((String)columnName), key, value);
    }

    public boolean isIdempotent();
}

