/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.querybuilder.update;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.QueryBuilderDsl;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Assignment;
import com.datastax.oss.driver.api.querybuilder.update.UpdateWithAssignments;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;

public interface OngoingAssignment {
    @NonNull
    public UpdateWithAssignments set(@NonNull Assignment var1);

    @NonNull
    public UpdateWithAssignments set(@NonNull Iterable<Assignment> var1);

    @NonNull
    default public UpdateWithAssignments set(Assignment ... assignments) {
        return this.set(Arrays.asList(assignments));
    }

    @NonNull
    default public UpdateWithAssignments setColumn(@NonNull CqlIdentifier columnId, @NonNull Term value) {
        return this.set(Assignment.setColumn(columnId, value));
    }

    @NonNull
    default public UpdateWithAssignments setColumn(@NonNull String columnName, @NonNull Term value) {
        return this.setColumn(CqlIdentifier.fromCql((String)columnName), value);
    }

    @NonNull
    default public UpdateWithAssignments setField(@NonNull CqlIdentifier columnId, @NonNull CqlIdentifier fieldId, @NonNull Term value) {
        return this.set(Assignment.setField(columnId, fieldId, value));
    }

    @NonNull
    default public UpdateWithAssignments setField(@NonNull String columnName, @NonNull String fieldName, @NonNull Term value) {
        return this.setField(CqlIdentifier.fromCql((String)columnName), CqlIdentifier.fromCql((String)fieldName), value);
    }

    @NonNull
    default public UpdateWithAssignments setMapValue(@NonNull CqlIdentifier columnId, @NonNull Term index, @NonNull Term value) {
        return this.set(Assignment.setMapValue(columnId, index, value));
    }

    @NonNull
    default public UpdateWithAssignments setMapValue(@NonNull String columnName, @NonNull Term index, @NonNull Term value) {
        return this.setMapValue(CqlIdentifier.fromCql((String)columnName), index, value);
    }

    @NonNull
    default public UpdateWithAssignments increment(@NonNull CqlIdentifier columnId, @NonNull Term amount) {
        return this.set(Assignment.increment(columnId, amount));
    }

    @NonNull
    default public UpdateWithAssignments increment(@NonNull String columnName, @NonNull Term amount) {
        return this.increment(CqlIdentifier.fromCql((String)columnName), amount);
    }

    @NonNull
    default public UpdateWithAssignments increment(@NonNull CqlIdentifier columnId) {
        return this.increment(columnId, (Term)QueryBuilderDsl.literal(1));
    }

    @NonNull
    default public UpdateWithAssignments increment(@NonNull String columnName) {
        return this.increment(CqlIdentifier.fromCql((String)columnName));
    }

    @NonNull
    default public UpdateWithAssignments decrement(@NonNull CqlIdentifier columnId, @NonNull Term amount) {
        return this.set(Assignment.decrement(columnId, amount));
    }

    @NonNull
    default public UpdateWithAssignments decrement(@NonNull String columnName, @NonNull Term amount) {
        return this.decrement(CqlIdentifier.fromCql((String)columnName), amount);
    }

    @NonNull
    default public UpdateWithAssignments decrement(@NonNull CqlIdentifier columnId) {
        return this.decrement(columnId, (Term)QueryBuilderDsl.literal(1));
    }

    @NonNull
    default public UpdateWithAssignments decrement(@NonNull String columnName) {
        return this.decrement(CqlIdentifier.fromCql((String)columnName));
    }

    @NonNull
    default public UpdateWithAssignments append(@NonNull CqlIdentifier columnId, @NonNull Term suffix) {
        return this.set(Assignment.append(columnId, suffix));
    }

    @NonNull
    default public UpdateWithAssignments append(@NonNull String columnName, @NonNull Term suffix) {
        return this.append(CqlIdentifier.fromCql((String)columnName), suffix);
    }

    @NonNull
    default public UpdateWithAssignments appendListElement(@NonNull CqlIdentifier columnId, @NonNull Term suffix) {
        return this.set(Assignment.appendListElement(columnId, suffix));
    }

    @NonNull
    default public UpdateWithAssignments appendListElement(@NonNull String columnName, @NonNull Term suffix) {
        return this.appendListElement(CqlIdentifier.fromCql((String)columnName), suffix);
    }

    @NonNull
    default public UpdateWithAssignments appendSetElement(@NonNull CqlIdentifier columnId, @NonNull Term suffix) {
        return this.set(Assignment.appendSetElement(columnId, suffix));
    }

    @NonNull
    default public UpdateWithAssignments appendSetElement(@NonNull String columnName, @NonNull Term suffix) {
        return this.appendSetElement(CqlIdentifier.fromCql((String)columnName), suffix);
    }

    @NonNull
    default public UpdateWithAssignments appendMapEntry(@NonNull CqlIdentifier columnId, @NonNull Term key, @NonNull Term value) {
        return this.set(Assignment.appendMapEntry(columnId, key, value));
    }

    @NonNull
    default public UpdateWithAssignments appendMapEntry(@NonNull String columnName, @NonNull Term key, @NonNull Term value) {
        return this.appendMapEntry(CqlIdentifier.fromCql((String)columnName), key, value);
    }

    @NonNull
    default public UpdateWithAssignments prepend(@NonNull CqlIdentifier columnId, @NonNull Term prefix) {
        return this.set(Assignment.prepend(columnId, prefix));
    }

    @NonNull
    default public UpdateWithAssignments prepend(@NonNull String columnName, @NonNull Term prefix) {
        return this.prepend(CqlIdentifier.fromCql((String)columnName), prefix);
    }

    @NonNull
    default public UpdateWithAssignments prependListElement(@NonNull CqlIdentifier columnId, @NonNull Term suffix) {
        return this.set(Assignment.prependListElement(columnId, suffix));
    }

    @NonNull
    default public UpdateWithAssignments prependListElement(@NonNull String columnName, @NonNull Term suffix) {
        return this.prependListElement(CqlIdentifier.fromCql((String)columnName), suffix);
    }

    @NonNull
    default public UpdateWithAssignments prependSetElement(@NonNull CqlIdentifier columnId, @NonNull Term suffix) {
        return this.set(Assignment.prependSetElement(columnId, suffix));
    }

    @NonNull
    default public UpdateWithAssignments prependSetElement(@NonNull String columnName, @NonNull Term suffix) {
        return this.prependSetElement(CqlIdentifier.fromCql((String)columnName), suffix);
    }

    @NonNull
    default public UpdateWithAssignments prependMapEntry(@NonNull CqlIdentifier columnId, @NonNull Term key, @NonNull Term value) {
        return this.set(Assignment.prependMapEntry(columnId, key, value));
    }

    @NonNull
    default public UpdateWithAssignments prependMapEntry(@NonNull String columnName, @NonNull Term key, @NonNull Term value) {
        return this.prependMapEntry(CqlIdentifier.fromCql((String)columnName), key, value);
    }

    @NonNull
    default public UpdateWithAssignments remove(@NonNull CqlIdentifier columnId, @NonNull Term collectionToRemove) {
        return this.set(Assignment.remove(columnId, collectionToRemove));
    }

    @NonNull
    default public UpdateWithAssignments remove(@NonNull String columnName, @NonNull Term collectionToRemove) {
        return this.remove(CqlIdentifier.fromCql((String)columnName), collectionToRemove);
    }

    @NonNull
    default public UpdateWithAssignments removeListElement(@NonNull CqlIdentifier columnId, @NonNull Term suffix) {
        return this.set(Assignment.removeListElement(columnId, suffix));
    }

    @NonNull
    default public UpdateWithAssignments removeListElement(@NonNull String columnName, @NonNull Term suffix) {
        return this.removeListElement(CqlIdentifier.fromCql((String)columnName), suffix);
    }

    @NonNull
    default public UpdateWithAssignments removeSetElement(@NonNull CqlIdentifier columnId, @NonNull Term suffix) {
        return this.set(Assignment.removeSetElement(columnId, suffix));
    }

    @NonNull
    default public UpdateWithAssignments removeSetElement(@NonNull String columnName, @NonNull Term suffix) {
        return this.removeSetElement(CqlIdentifier.fromCql((String)columnName), suffix);
    }

    @NonNull
    default public UpdateWithAssignments removeMapEntry(@NonNull CqlIdentifier columnId, @NonNull Term key, @NonNull Term value) {
        return this.set(Assignment.removeMapEntry(columnId, key, value));
    }

    @NonNull
    default public UpdateWithAssignments removeMapEntry(@NonNull String columnName, @NonNull Term key, @NonNull Term value) {
        return this.removeMapEntry(CqlIdentifier.fromCql((String)columnName), key, value);
    }
}

