/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.select;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.querybuilder.select.Selector;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class MapSelector
implements Selector {
    private final Map<Selector, Selector> elementSelectors;
    private final DataType keyType;
    private final DataType valueType;
    private final CqlIdentifier alias;

    public MapSelector(@NonNull Map<Selector, Selector> elementSelectors, @Nullable DataType keyType, @Nullable DataType valueType) {
        this(elementSelectors, keyType, valueType, null);
    }

    public MapSelector(@NonNull Map<Selector, Selector> elementSelectors, @Nullable DataType keyType, @Nullable DataType valueType, @Nullable CqlIdentifier alias) {
        Preconditions.checkNotNull(elementSelectors);
        Preconditions.checkArgument((!elementSelectors.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one key/value pair");
        MapSelector.checkNoAlias(elementSelectors);
        Preconditions.checkArgument((keyType == null == (valueType == null) ? 1 : 0) != 0, (Object)"Key and value type must be either both null or both non-null");
        this.elementSelectors = elementSelectors;
        this.keyType = keyType;
        this.valueType = valueType;
        this.alias = alias;
    }

    @Override
    @NonNull
    public Selector as(@NonNull CqlIdentifier alias) {
        return new MapSelector(this.elementSelectors, this.keyType, this.valueType, alias);
    }

    @Override
    public void appendTo(@NonNull StringBuilder builder) {
        if (this.keyType != null) {
            assert (this.valueType != null);
            builder.append("(map<").append(this.keyType.asCql(false, true)).append(',').append(this.valueType.asCql(false, true)).append(">)");
        }
        builder.append("{");
        boolean first = true;
        for (Map.Entry<Selector, Selector> entry : this.elementSelectors.entrySet()) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            entry.getKey().appendTo(builder);
            builder.append(":");
            entry.getValue().appendTo(builder);
        }
        builder.append("}");
    }

    @NonNull
    public Map<Selector, Selector> getElementSelectors() {
        return this.elementSelectors;
    }

    @Nullable
    public DataType getKeyType() {
        return this.keyType;
    }

    @Nullable
    public DataType getValueType() {
        return this.valueType;
    }

    @Override
    @Nullable
    public CqlIdentifier getAlias() {
        return this.alias;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof MapSelector) {
            MapSelector that = (MapSelector)other;
            return this.elementSelectors.equals(that.elementSelectors) && Objects.equals(this.keyType, that.keyType) && Objects.equals(this.valueType, that.valueType) && Objects.equals(this.alias, that.alias);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.elementSelectors, this.keyType, this.valueType, this.alias);
    }

    private static void checkNoAlias(Map<Selector, Selector> elementSelectors) {
        String offendingAliases = null;
        for (Map.Entry<Selector, Selector> entry : elementSelectors.entrySet()) {
            offendingAliases = MapSelector.appendIfNotNull(offendingAliases, entry.getKey().getAlias());
            offendingAliases = MapSelector.appendIfNotNull(offendingAliases, entry.getValue().getAlias());
        }
        if (offendingAliases != null) {
            throw new IllegalArgumentException("Can't use aliases in selection map, offending aliases: " + offendingAliases);
        }
    }

    private static String appendIfNotNull(String offendingAliases, CqlIdentifier alias) {
        if (alias == null) {
            return offendingAliases;
        }
        if (offendingAliases == null) {
            return alias.asCql(true);
        }
        return offendingAliases + ", " + alias.asCql(true);
    }
}

