/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.update;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatementBuilder;
import com.datastax.oss.driver.api.querybuilder.BindMarker;
import com.datastax.oss.driver.api.querybuilder.condition.Condition;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.update.Assignment;
import com.datastax.oss.driver.api.querybuilder.update.Update;
import com.datastax.oss.driver.api.querybuilder.update.UpdateStart;
import com.datastax.oss.driver.api.querybuilder.update.UpdateWithAssignments;
import com.datastax.oss.driver.internal.querybuilder.CqlHelper;
import com.datastax.oss.driver.internal.querybuilder.ImmutableCollections;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultUpdate
implements UpdateStart,
UpdateWithAssignments,
Update {
    private final CqlIdentifier keyspace;
    private final CqlIdentifier table;
    private final Object timestamp;
    private final ImmutableList<Assignment> assignments;
    private final ImmutableList<Relation> relations;
    private final boolean ifExists;
    private final ImmutableList<Condition> conditions;

    public DefaultUpdate(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier table) {
        this(keyspace, table, null, (ImmutableList<Assignment>)ImmutableList.of(), (ImmutableList<Relation>)ImmutableList.of(), false, (ImmutableList<Condition>)ImmutableList.of());
    }

    public DefaultUpdate(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier table, @Nullable Object timestamp, @NonNull ImmutableList<Assignment> assignments, @NonNull ImmutableList<Relation> relations, boolean ifExists, @NonNull ImmutableList<Condition> conditions) {
        this.keyspace = keyspace;
        this.table = table;
        this.timestamp = timestamp;
        this.assignments = assignments;
        this.relations = relations;
        this.ifExists = ifExists;
        this.conditions = conditions;
    }

    @Override
    @NonNull
    public UpdateStart usingTimestamp(long newTimestamp) {
        return new DefaultUpdate(this.keyspace, this.table, newTimestamp, this.assignments, this.relations, this.ifExists, this.conditions);
    }

    @Override
    @NonNull
    public UpdateStart usingTimestamp(@NonNull BindMarker newTimestamp) {
        return new DefaultUpdate(this.keyspace, this.table, newTimestamp, this.assignments, this.relations, this.ifExists, this.conditions);
    }

    @Override
    @NonNull
    public UpdateWithAssignments set(@NonNull Assignment assignment) {
        return this.withAssignments(ImmutableCollections.append(this.assignments, assignment));
    }

    @Override
    @NonNull
    public UpdateWithAssignments set(@NonNull Iterable<Assignment> additionalAssignments) {
        return this.withAssignments(ImmutableCollections.concat(this.assignments, additionalAssignments));
    }

    @NonNull
    public UpdateWithAssignments withAssignments(@NonNull ImmutableList<Assignment> newAssignments) {
        return new DefaultUpdate(this.keyspace, this.table, this.timestamp, newAssignments, this.relations, this.ifExists, this.conditions);
    }

    @Override
    @NonNull
    public Update where(@NonNull Relation relation) {
        return this.withRelations(ImmutableCollections.append(this.relations, relation));
    }

    @Override
    @NonNull
    public Update where(@NonNull Iterable<Relation> additionalRelations) {
        return this.withRelations(ImmutableCollections.concat(this.relations, additionalRelations));
    }

    @NonNull
    public Update withRelations(@NonNull ImmutableList<Relation> newRelations) {
        return new DefaultUpdate(this.keyspace, this.table, this.timestamp, this.assignments, newRelations, this.ifExists, this.conditions);
    }

    @Override
    @NonNull
    public Update ifExists() {
        return new DefaultUpdate(this.keyspace, this.table, this.timestamp, this.assignments, this.relations, true, this.conditions);
    }

    @Override
    @NonNull
    public Update if_(@NonNull Condition condition) {
        return this.withConditions(ImmutableCollections.append(this.conditions, condition));
    }

    @Override
    @NonNull
    public Update if_(@NonNull Iterable<Condition> additionalConditions) {
        return this.withConditions(ImmutableCollections.concat(this.conditions, additionalConditions));
    }

    @NonNull
    public Update withConditions(@NonNull ImmutableList<Condition> newConditions) {
        return new DefaultUpdate(this.keyspace, this.table, this.timestamp, this.assignments, this.relations, false, newConditions);
    }

    @Override
    @NonNull
    public String asCql() {
        StringBuilder builder = new StringBuilder("UPDATE ");
        CqlHelper.qualify(this.keyspace, this.table, builder);
        if (this.timestamp != null) {
            builder.append(" USING TIMESTAMP ");
            if (this.timestamp instanceof BindMarker) {
                ((BindMarker)this.timestamp).appendTo(builder);
            } else {
                builder.append(this.timestamp);
            }
        }
        CqlHelper.append(this.assignments, builder, " SET ", ", ", null);
        CqlHelper.append(this.relations, builder, " WHERE ", " AND ", null);
        if (this.ifExists) {
            builder.append(" IF EXISTS");
        } else {
            CqlHelper.append(this.conditions, builder, " IF ", " AND ", null);
        }
        return builder.toString();
    }

    @Override
    @NonNull
    public SimpleStatement build() {
        return this.builder().build();
    }

    @Override
    @NonNull
    public SimpleStatement build(Object ... values) {
        return this.builder().addPositionalValues(values).build();
    }

    @Override
    @NonNull
    public SimpleStatement build(@NonNull Map<String, Object> namedValues) {
        SimpleStatementBuilder builder = this.builder();
        for (Map.Entry<String, Object> entry : namedValues.entrySet()) {
            builder.addNamedValue(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    @Override
    @NonNull
    public SimpleStatementBuilder builder() {
        return (SimpleStatementBuilder)SimpleStatement.builder((String)this.asCql()).setIdempotence(Boolean.valueOf(this.isIdempotent()));
    }

    public boolean isIdempotent() {
        if (!this.conditions.isEmpty() || this.ifExists) {
            return false;
        }
        for (Assignment assignment : this.assignments) {
            if (assignment.isIdempotent()) continue;
            return false;
        }
        for (Relation relation : this.relations) {
            if (relation.isIdempotent()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public CqlIdentifier getKeyspace() {
        return this.keyspace;
    }

    @NonNull
    public CqlIdentifier getTable() {
        return this.table;
    }

    @Nullable
    public Object getTimestamp() {
        return this.timestamp;
    }

    @NonNull
    public ImmutableList<Assignment> getAssignments() {
        return this.assignments;
    }

    @NonNull
    public ImmutableList<Relation> getRelations() {
        return this.relations;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    @NonNull
    public ImmutableList<Condition> getConditions() {
        return this.conditions;
    }

    public String toString() {
        return this.asCql();
    }
}

