/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.relation;

import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.internal.querybuilder.lhs.LeftOperand;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultRelation
implements Relation {
    private final LeftOperand leftOperand;
    private final String operator;
    private final Term rightOperand;

    public DefaultRelation(@NonNull LeftOperand leftOperand, @NonNull String operator, @Nullable Term rightOperand) {
        Preconditions.checkNotNull((Object)leftOperand);
        Preconditions.checkNotNull((Object)operator);
        this.leftOperand = leftOperand;
        this.operator = operator;
        this.rightOperand = rightOperand;
    }

    @Override
    public void appendTo(@NonNull StringBuilder builder) {
        this.leftOperand.appendTo(builder);
        builder.append(this.operator);
        if (this.rightOperand != null) {
            this.rightOperand.appendTo(builder);
        }
    }

    @Override
    public boolean isIdempotent() {
        return this.rightOperand.isIdempotent();
    }

    @NonNull
    public LeftOperand getLeftOperand() {
        return this.leftOperand;
    }

    @NonNull
    public String getOperator() {
        return this.operator;
    }

    @Nullable
    public Term getRightOperand() {
        return this.rightOperand;
    }
}

