/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.update;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Assignment;
import edu.umd.cs.findbugs.annotations.NonNull;
import net.jcip.annotations.Immutable;

@Immutable
public class PrependAssignment
implements Assignment {
    private final CqlIdentifier columnId;
    private final Term prefix;

    public PrependAssignment(@NonNull CqlIdentifier columnId, @NonNull Term prefix) {
        this.columnId = columnId;
        this.prefix = prefix;
    }

    @Override
    public void appendTo(@NonNull StringBuilder builder) {
        String column = this.columnId.asCql(true);
        builder.append(column).append('=');
        this.prefix.appendTo(builder);
        builder.append('+').append(column);
    }

    @Override
    public boolean isIdempotent() {
        return false;
    }

    @NonNull
    public CqlIdentifier getColumnId() {
        return this.columnId;
    }

    @NonNull
    public Term getPrefix() {
        return this.prefix;
    }
}

