/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.testinfra.session;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatementBuilder;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeStateListener;
import com.datastax.oss.driver.api.core.metadata.schema.SchemaChangeListener;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.api.core.session.SessionBuilder;
import com.datastax.oss.driver.api.testinfra.CassandraResourceRule;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SessionUtils.class);
    private static final AtomicInteger keyspaceId = new AtomicInteger();
    private static final String DEFAULT_SESSION_CLASS_NAME = CqlSession.class.getName();
    private static final String SESSION_BUILDER_CLASS = System.getProperty("session.builder", DEFAULT_SESSION_CLASS_NAME);

    public static <SessionT extends Session> SessionBuilder<?, SessionT> baseBuilder() {
        try {
            Class<?> clazz = Class.forName(SESSION_BUILDER_CLASS);
            Method m = clazz.getMethod("builder", new Class[0]);
            return (SessionBuilder)m.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            LOG.warn("Could not construct SessionBuilder from {} using builder(), using default implementation.", (Object)SESSION_BUILDER_CLASS, (Object)e);
            return CqlSession.builder();
        }
    }

    public static ProgrammaticDriverConfigLoaderBuilder configLoaderBuilder() {
        try {
            Class<?> clazz = Class.forName(SESSION_BUILDER_CLASS);
            Method m = clazz.getMethod("configLoaderBuilder", new Class[0]);
            return (ProgrammaticDriverConfigLoaderBuilder)m.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            if (!SESSION_BUILDER_CLASS.equals(DEFAULT_SESSION_CLASS_NAME)) {
                LOG.warn("Could not construct ProgrammaticDriverConfigLoaderBuilder from {} using configLoaderBuilder(), using default implementation.", (Object)SESSION_BUILDER_CLASS, (Object)e);
            }
            return DriverConfigLoader.programmaticBuilder();
        }
    }

    public static <SessionT extends Session> SessionT newSession(CassandraResourceRule cassandraResource) {
        return SessionUtils.newSession(cassandraResource, null, null);
    }

    public static <SessionT extends Session> SessionT newSession(CassandraResourceRule cassandraResource, CqlIdentifier keyspace) {
        return SessionUtils.newSession(cassandraResource, keyspace, null, null, null);
    }

    public static <SessionT extends Session> SessionT newSession(CassandraResourceRule cassandraResourceRule, DriverConfigLoader loader) {
        return SessionUtils.newSession(cassandraResourceRule, null, null, null, null, loader);
    }

    public static <SessionT extends Session> SessionT newSession(CassandraResourceRule cassandraResourceRule, CqlIdentifier keyspace, DriverConfigLoader loader) {
        return SessionUtils.newSession(cassandraResourceRule, keyspace, null, null, null, loader);
    }

    private static SessionBuilder builder(CassandraResourceRule cassandraResource, CqlIdentifier keyspace, NodeStateListener nodeStateListener, SchemaChangeListener schemaChangeListener, Predicate<Node> nodeFilter) {
        SessionBuilder builder = SessionUtils.baseBuilder().addContactEndPoints(cassandraResource.getContactPoints()).withKeyspace(keyspace).withNodeStateListener(nodeStateListener).withSchemaChangeListener(schemaChangeListener);
        if (nodeFilter != null) {
            builder = builder.withNodeFilter(nodeFilter);
        }
        return builder;
    }

    public static <SessionT extends Session> SessionT newSession(CassandraResourceRule cassandraResource, CqlIdentifier keyspace, NodeStateListener nodeStateListener, SchemaChangeListener schemaChangeListener, Predicate<Node> nodeFilter) {
        SessionBuilder builder = SessionUtils.builder(cassandraResource, keyspace, nodeStateListener, schemaChangeListener, nodeFilter);
        return (SessionT)((Session)builder.build());
    }

    public static <SessionT extends Session> SessionT newSession(CassandraResourceRule cassandraResource, CqlIdentifier keyspace, NodeStateListener nodeStateListener, SchemaChangeListener schemaChangeListener, Predicate<Node> nodeFilter, DriverConfigLoader loader) {
        SessionBuilder builder = SessionUtils.builder(cassandraResource, keyspace, nodeStateListener, schemaChangeListener, nodeFilter);
        return (SessionT)((Session)builder.withConfigLoader(loader).build());
    }

    public static CqlIdentifier uniqueKeyspaceId() {
        return CqlIdentifier.fromCql((String)("ks_" + keyspaceId.getAndIncrement()));
    }

    public static void createKeyspace(Session session, CqlIdentifier keyspace, DriverExecutionProfile profile) {
        SimpleStatement createKeyspace = ((SimpleStatementBuilder)SimpleStatement.builder((String)String.format("CREATE KEYSPACE %s WITH REPLICATION = { 'class' : 'SimpleStrategy', 'replication_factor' : 1 };", keyspace.asCql(false))).setExecutionProfile(profile)).build();
        session.execute((Request)createKeyspace, Statement.SYNC);
    }

    public static void createKeyspace(Session session, CqlIdentifier keyspace) {
        SessionUtils.createKeyspace(session, keyspace, SessionUtils.slowProfile(session));
    }

    public static void dropKeyspace(Session session, CqlIdentifier keyspace, DriverExecutionProfile profile) {
        session.execute((Request)((SimpleStatementBuilder)SimpleStatement.builder((String)String.format("DROP KEYSPACE IF EXISTS %s", keyspace.asCql(false))).setExecutionProfile(profile)).build(), Statement.SYNC);
    }

    public static void dropKeyspace(Session session, CqlIdentifier keyspace) {
        SessionUtils.dropKeyspace(session, keyspace, SessionUtils.slowProfile(session));
    }

    public static DriverExecutionProfile slowProfile(Session session) {
        return (DriverExecutionProfile)session.getContext().getConfig().getDefaultProfile().withString((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT, "30s");
    }
}

