/*
 * Copyright (C) 2017-2017 DataStax Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.datastax.oss.protocol.internal;

/** @param <B> the binary representation to compress. */
public interface Compressor<B> {
  static <B> Compressor<B> none() {
    return new NoopCompressor<>();
  }

  /**
   * The name of the algorithm used.
   *
   * <p>It's the string that will be used in the {@code STARTUP} message. Null or empty means no
   * compression.
   */
  String algorithm();

  B compress(B uncompressed);

  B decompress(B compressed);
}
