/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.deployment.internal;

import com.datastax.dse.driver.api.core.auth.ProgrammaticDseGssApiAuthProvider;
import com.datastax.dse.driver.internal.core.auth.DseGssApiAuthProvider;
import com.datastax.dse.driver.internal.core.tracker.MultiplexingRequestTracker;
import com.datastax.oss.driver.api.core.metadata.SafeInitNodeStateListener;
import com.datastax.oss.driver.api.core.ssl.ProgrammaticSslEngineFactory;
import com.datastax.oss.driver.internal.core.addresstranslation.Ec2MultiRegionAddressTranslator;
import com.datastax.oss.driver.internal.core.addresstranslation.PassThroughAddressTranslator;
import com.datastax.oss.driver.internal.core.auth.PlainTextAuthProvider;
import com.datastax.oss.driver.internal.core.auth.ProgrammaticPlainTextAuthProvider;
import com.datastax.oss.driver.internal.core.connection.ConstantReconnectionPolicy;
import com.datastax.oss.driver.internal.core.connection.ExponentialReconnectionPolicy;
import com.datastax.oss.driver.internal.core.loadbalancing.DcInferringLoadBalancingPolicy;
import com.datastax.oss.driver.internal.core.loadbalancing.DefaultLoadBalancingPolicy;
import com.datastax.oss.driver.internal.core.metadata.MetadataManager;
import com.datastax.oss.driver.internal.core.metadata.NoopNodeStateListener;
import com.datastax.oss.driver.internal.core.metadata.schema.NoopSchemaChangeListener;
import com.datastax.oss.driver.internal.core.metrics.DefaultMetricsFactory;
import com.datastax.oss.driver.internal.core.metrics.TaggingMetricIdGenerator;
import com.datastax.oss.driver.internal.core.os.Native;
import com.datastax.oss.driver.internal.core.retry.ConsistencyDowngradingRetryPolicy;
import com.datastax.oss.driver.internal.core.retry.DefaultRetryPolicy;
import com.datastax.oss.driver.internal.core.session.throttling.ConcurrencyLimitingRequestThrottler;
import com.datastax.oss.driver.internal.core.session.throttling.PassThroughRequestThrottler;
import com.datastax.oss.driver.internal.core.session.throttling.RateLimitingRequestThrottler;
import com.datastax.oss.driver.internal.core.specex.ConstantSpeculativeExecutionPolicy;
import com.datastax.oss.driver.internal.core.specex.NoSpeculativeExecutionPolicy;
import com.datastax.oss.driver.internal.core.ssl.DefaultSslEngineFactory;
import com.datastax.oss.driver.internal.core.ssl.SniSslEngineFactory;
import com.datastax.oss.driver.internal.core.time.AtomicTimestampGenerator;
import com.datastax.oss.driver.internal.core.time.ServerSideTimestampGenerator;
import com.datastax.oss.driver.internal.core.time.ThreadLocalTimestampGenerator;
import com.datastax.oss.driver.internal.core.tracker.NoopRequestTracker;
import com.datastax.oss.driver.internal.core.tracker.RequestLogger;
import com.datastax.oss.quarkus.deployment.api.CassandraClientBuildTimeConfig;
import com.datastax.oss.quarkus.deployment.internal.CassandraClientBuildItem;
import com.datastax.oss.quarkus.runtime.api.session.QuarkusCqlSession;
import com.datastax.oss.quarkus.runtime.internal.quarkus.CassandraClientProducer;
import com.datastax.oss.quarkus.runtime.internal.quarkus.CassandraClientRecorder;
import com.datastax.oss.quarkus.runtime.internal.quarkus.CassandraClientStarter;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.SyntheticBeansRuntimeInitBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import org.jboss.jandex.DotName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CassandraClientProcessor {
    public static final String CASSANDRA_CLIENT = "cassandra-client";
    private static final Logger LOG = LoggerFactory.getLogger(CassandraClientProcessor.class);

    CassandraClientProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(CASSANDRA_CLIENT);
    }

    @BuildStep
    List<ReflectiveClassBuildItem> registerGraphForReflection() {
        return Arrays.asList(new ReflectiveClassBuildItem(true, true, new String[]{"org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal"}), new ReflectiveClassBuildItem(true, true, new String[]{"org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerIoRegistryV3d0"}));
    }

    @BuildStep
    ReflectiveClassBuildItem registerGeometryForReflection() {
        return new ReflectiveClassBuildItem(true, true, new String[]{"com.esri.core.geometry.ogc.OGCGeometry"});
    }

    @BuildStep
    List<ReflectiveClassBuildItem> registerJsonForReflection() {
        return Arrays.asList(new ReflectiveClassBuildItem(true, true, new String[]{"com.fasterxml.jackson.core.JsonParser"}), new ReflectiveClassBuildItem(true, true, new String[]{"com.fasterxml.jackson.databind.ObjectMapper"}));
    }

    @BuildStep
    List<ReflectiveClassBuildItem> registerReactiveForReflection() {
        return Collections.singletonList(new ReflectiveClassBuildItem(true, true, new String[]{"org.reactivestreams.Publisher"}));
    }

    @BuildStep
    List<ReflectiveClassBuildItem> registerRetryPoliciesForReflection() {
        return Arrays.asList(new ReflectiveClassBuildItem(true, true, new String[]{DefaultRetryPolicy.class.getName()}), new ReflectiveClassBuildItem(true, true, new String[]{ConsistencyDowngradingRetryPolicy.class.getName()}));
    }

    @BuildStep
    List<ReflectiveClassBuildItem> registerSchemaChangeListenersForReflection() {
        return Collections.singletonList(new ReflectiveClassBuildItem(true, true, new String[]{NoopSchemaChangeListener.class.getName()}));
    }

    @BuildStep
    List<ReflectiveClassBuildItem> registerStateListenersForRefection() {
        return Arrays.asList(new ReflectiveClassBuildItem(true, true, new String[]{NoopNodeStateListener.class.getName()}), new ReflectiveClassBuildItem(true, true, new String[]{SafeInitNodeStateListener.class.getName()}));
    }

    @BuildStep
    List<ReflectiveClassBuildItem> registerSpeculativeExecutionPoliciesForReflection() {
        return Arrays.asList(new ReflectiveClassBuildItem(true, true, new String[]{NoSpeculativeExecutionPolicy.class.getName()}), new ReflectiveClassBuildItem(true, true, new String[]{ConstantSpeculativeExecutionPolicy.class.getName()}));
    }

    @BuildStep
    List<ReflectiveClassBuildItem> registerAddressTranslatorsForReflection() {
        return Arrays.asList(new ReflectiveClassBuildItem(true, true, new String[]{Ec2MultiRegionAddressTranslator.class.getName()}), new ReflectiveClassBuildItem(true, true, new String[]{PassThroughAddressTranslator.class.getName()}));
    }

    @BuildStep
    List<ReflectiveClassBuildItem> registerLoadBalancingPoliciesForReflection() {
        return Arrays.asList(new ReflectiveClassBuildItem(true, true, new String[]{DefaultLoadBalancingPolicy.class.getName()}), new ReflectiveClassBuildItem(true, true, new String[]{DcInferringLoadBalancingPolicy.class.getName()}));
    }

    @BuildStep
    List<ReflectiveClassBuildItem> registerReconnectionPoliciesForReflection() {
        return Arrays.asList(new ReflectiveClassBuildItem(true, true, new String[]{ExponentialReconnectionPolicy.class.getName()}), new ReflectiveClassBuildItem(true, true, new String[]{ConstantReconnectionPolicy.class.getName()}));
    }

    @BuildStep
    List<ReflectiveClassBuildItem> registerRequestThrottlersForReflection() {
        return Arrays.asList(new ReflectiveClassBuildItem(true, true, new String[]{PassThroughRequestThrottler.class.getName()}), new ReflectiveClassBuildItem(true, true, new String[]{ConcurrencyLimitingRequestThrottler.class.getName()}), new ReflectiveClassBuildItem(true, true, new String[]{RateLimitingRequestThrottler.class.getName()}));
    }

    @BuildStep
    List<ReflectiveClassBuildItem> registerRequestTrackersForReflection() {
        return Arrays.asList(new ReflectiveClassBuildItem(true, true, new String[]{NoopRequestTracker.class.getName()}), new ReflectiveClassBuildItem(true, true, new String[]{MultiplexingRequestTracker.class.getName()}), new ReflectiveClassBuildItem(true, true, new String[]{RequestLogger.class.getName()}));
    }

    @BuildStep
    List<ReflectiveClassBuildItem> registerLz4ForReflection(CassandraClientBuildTimeConfig buildTimeConfig) {
        if (buildTimeConfig.protocolCompression.equalsIgnoreCase("lz4")) {
            return Arrays.asList(new ReflectiveClassBuildItem(true, true, new String[]{"net.jpountz.lz4.LZ4Compressor"}), new ReflectiveClassBuildItem(true, true, new String[]{"net.jpountz.lz4.LZ4JavaSafeCompressor"}), new ReflectiveClassBuildItem(true, true, new String[]{"net.jpountz.lz4.LZ4HCJavaSafeCompressor"}), new ReflectiveClassBuildItem(true, true, new String[]{"net.jpountz.lz4.LZ4JavaSafeFastDecompressor"}), new ReflectiveClassBuildItem(true, true, new String[]{"net.jpountz.lz4.LZ4JavaSafeSafeDecompressor"}), new ReflectiveClassBuildItem(true, true, new String[]{"net.jpountz.lz4.LZ4JavaUnsafeCompressor"}), new ReflectiveClassBuildItem(true, true, new String[]{"net.jpountz.lz4.LZ4HCJavaUnsafeCompressor"}), new ReflectiveClassBuildItem(true, true, new String[]{"net.jpountz.lz4.LZ4JavaUnsafeFastDecompressor"}), new ReflectiveClassBuildItem(true, true, new String[]{"net.jpountz.lz4.LZ4JavaUnsafeSafeDecompressor"}));
        }
        return Collections.emptyList();
    }

    @BuildStep
    List<ReflectiveClassBuildItem> registerSSLFactoryForReflection() {
        return Arrays.asList(new ReflectiveClassBuildItem(true, true, new String[]{DefaultSslEngineFactory.class.getName()}), new ReflectiveClassBuildItem(true, true, new String[]{ProgrammaticSslEngineFactory.class.getName()}), new ReflectiveClassBuildItem(true, true, new String[]{SniSslEngineFactory.class.getName()}));
    }

    @BuildStep
    void setupSslSupport(BuildProducer<ExtensionSslNativeSupportBuildItem> extensionSslNativeSupport) {
        extensionSslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(CASSANDRA_CLIENT));
    }

    @BuildStep
    List<ReflectiveClassBuildItem> registerAuthProviderForReflection() {
        return Arrays.asList(new ReflectiveClassBuildItem(true, true, new String[]{PlainTextAuthProvider.class.getName()}), new ReflectiveClassBuildItem(true, true, new String[]{DseGssApiAuthProvider.class.getName()}), new ReflectiveClassBuildItem(true, true, new String[]{ProgrammaticPlainTextAuthProvider.class.getName()}), new ReflectiveClassBuildItem(true, true, new String[]{ProgrammaticDseGssApiAuthProvider.class.getName()}));
    }

    @BuildStep
    List<ReflectiveClassBuildItem> registerTimestampGeneratorsForReflection() {
        return Arrays.asList(new ReflectiveClassBuildItem(true, true, new String[]{AtomicTimestampGenerator.class.getName()}), new ReflectiveClassBuildItem(true, true, new String[]{ThreadLocalTimestampGenerator.class.getName()}), new ReflectiveClassBuildItem(true, true, new String[]{ServerSideTimestampGenerator.class.getName()}));
    }

    @BuildStep
    List<ReflectiveClassBuildItem> registerMetricsFactoriesForReflection(CassandraClientBuildTimeConfig buildTimeConfig, Optional<MetricsCapabilityBuildItem> metricsCapability) {
        if (buildTimeConfig.metricsEnabled && metricsCapability.isPresent()) {
            MetricsCapabilityBuildItem metricsCapabilityItem = metricsCapability.get();
            if (metricsCapabilityItem.metricsSupported("micrometer")) {
                return Arrays.asList(new ReflectiveClassBuildItem(true, true, new String[]{"com.datastax.oss.driver.internal.metrics.micrometer.MicrometerMetricsFactory"}), new ReflectiveClassBuildItem(true, true, new Class[]{TaggingMetricIdGenerator.class}));
            }
            if (metricsCapabilityItem.metricsSupported("smallrye-metrics")) {
                return Arrays.asList(new ReflectiveClassBuildItem(true, true, new String[]{"com.datastax.oss.driver.internal.metrics.microprofile.MicroProfileMetricsFactory"}), new ReflectiveClassBuildItem(true, true, new Class[]{TaggingMetricIdGenerator.class}));
            }
        }
        return Collections.singletonList(new ReflectiveClassBuildItem(true, true, new Class[]{DefaultMetricsFactory.class}));
    }

    @BuildStep
    UnremovableBeanBuildItem registerMetricsRegistry(Optional<MetricsCapabilityBuildItem> metricsCapability) {
        if (metricsCapability.isPresent()) {
            MetricsCapabilityBuildItem metricsCapabilityItem = metricsCapability.get();
            if (metricsCapabilityItem.metricsSupported("micrometer")) {
                return UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{DotName.createSimple((String)"io.micrometer.core.instrument.MeterRegistry")});
            }
            if (metricsCapabilityItem.metricsSupported("smallrye-metrics")) {
                return UnremovableBeanBuildItem.targetWithAnnotation((DotName)DotName.createSimple((String)"org.eclipse.microprofile.metrics.annotation.RegistryType"));
            }
        }
        return null;
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void configureMetrics(CassandraClientRecorder recorder, CassandraClientBuildTimeConfig buildTimeConfig, Optional<MetricsCapabilityBuildItem> metricsCapability, BeanContainerBuildItem beanContainer) {
        if (buildTimeConfig.metricsEnabled) {
            if (metricsCapability.isPresent()) {
                MetricsCapabilityBuildItem metricsCapabilityItem = metricsCapability.get();
                if (metricsCapabilityItem.metricsSupported("micrometer")) {
                    if (this.checkMicrometerMetricsFactoryPresent()) {
                        recorder.configureMicrometerMetrics();
                    } else {
                        LOG.warn("Micrometer metrics were enabled by configuration, but MicrometerMetricsFactory was not found.");
                        LOG.warn("Make sure to include a dependency to the java-driver-metrics-micrometer module.");
                    }
                } else if (metricsCapabilityItem.metricsSupported("smallrye-metrics")) {
                    if (this.checkMicroProfileMetricsFactoryPresent()) {
                        recorder.configureMicroProfileMetrics();
                    } else {
                        LOG.warn("MicroProfile metrics were enabled by configuration, but MicroProfileMetricsFactory was not found.");
                        LOG.warn("Make sure to include a dependency to the java-driver-metrics-microprofile module.");
                    }
                } else {
                    LOG.warn("Cassandra metrics were enabled by configuration, but the installed metrics capability is not supported.");
                    LOG.warn("Make sure to include a dependency to either quarkus-micrometer-registry-prometheus or quarkus-smallrye-metrics.");
                }
            } else {
                LOG.warn("Cassandra metrics were enabled by configuration, but no metrics capability is installed.");
                LOG.warn("Make sure to include a dependency to either quarkus-micrometer-registry-prometheus or quarkus-smallrye-metrics.");
            }
        } else {
            LOG.info("Cassandra metrics were disabled by configuration.");
        }
    }

    private boolean checkMicrometerMetricsFactoryPresent() {
        try {
            Class.forName("com.datastax.oss.driver.internal.metrics.micrometer.MicrometerMetricsFactory");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    private boolean checkMicroProfileMetricsFactoryPresent() {
        try {
            Class.forName("com.datastax.oss.driver.internal.metrics.microprofile.MicroProfileMetricsFactory");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void configureCompression(CassandraClientRecorder recorder, CassandraClientBuildTimeConfig buildTimeConfig, BeanContainerBuildItem beanContainer) {
        recorder.configureCompression(buildTimeConfig.protocolCompression);
    }

    @BuildStep
    AdditionalBeanBuildItem cassandraClientProducer() {
        return AdditionalBeanBuildItem.unremovableOf(CassandraClientProducer.class);
    }

    @BuildStep
    AdditionalBeanBuildItem cassandraClientStarter() {
        return AdditionalBeanBuildItem.builder().addBeanClass(CassandraClientStarter.class).build();
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Consume(value=SyntheticBeansRuntimeInitBuildItem.class)
    CassandraClientBuildItem cassandraClient(CassandraClientRecorder recorder, ShutdownContextBuildItem shutdown, BeanContainerBuildItem beanContainer) {
        return new CassandraClientBuildItem((RuntimeValue<CompletionStage<QuarkusCqlSession>>)recorder.buildClient((ShutdownContext)shutdown));
    }

    @BuildStep
    HealthBuildItem addHealthCheck(CassandraClientBuildTimeConfig buildTimeConfig) {
        return new HealthBuildItem("com.datastax.oss.quarkus.runtime.internal.health.CassandraAsyncHealthCheck", buildTimeConfig.healthEnabled);
    }

    @BuildStep
    RuntimeInitializedClassBuildItem runtimeMetadataManager() {
        return new RuntimeInitializedClassBuildItem(MetadataManager.class.getCanonicalName());
    }

    @BuildStep
    NativeImageResourceBuildItem referenceConf() {
        return new NativeImageResourceBuildItem(new String[]{"reference.conf"});
    }

    @BuildStep
    RuntimeInitializedClassBuildItem runtimeNative() {
        return new RuntimeInitializedClassBuildItem(Native.class.getCanonicalName());
    }
}

