/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.deployment.internal;

import com.datastax.oss.driver.internal.core.metadata.MetadataManager;
import com.datastax.oss.driver.internal.core.metrics.DefaultMetricsFactory;
import com.datastax.oss.driver.internal.core.metrics.TaggingMetricIdGenerator;
import com.datastax.oss.driver.internal.core.os.Native;
import com.datastax.oss.quarkus.deployment.api.CassandraClientBuildTimeConfig;
import com.datastax.oss.quarkus.deployment.internal.CassandraClientBuildItem;
import com.datastax.oss.quarkus.runtime.api.session.QuarkusCqlSession;
import com.datastax.oss.quarkus.runtime.internal.quarkus.CassandraClientProducer;
import com.datastax.oss.quarkus.runtime.internal.quarkus.CassandraClientRecorder;
import com.datastax.oss.quarkus.runtime.internal.quarkus.CassandraClientStarter;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.SyntheticBeansRuntimeInitBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.jandex.DotName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CassandraClientProcessor {
    public static final String CASSANDRA_CLIENT = "cassandra-client";
    private static final Logger LOG = LoggerFactory.getLogger(CassandraClientProcessor.class);

    CassandraClientProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(CASSANDRA_CLIENT);
    }

    @BuildStep
    List<ReflectiveClassBuildItem> registerGraphForReflection() {
        return Stream.of("org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal", "org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerIoRegistryV3d0", "org.apache.tinkerpop.shaded.jackson.databind.deser.std.StdDeserializer", "org.apache.tinkerpop.gremlin.structure.Graph", "org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph", "org.apache.tinkerpop.gremlin.structure.util.empty.EmptyGraph", "org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource").map(clzName -> ReflectiveClassBuildItem.builder((String[])new String[]{clzName}).methods(true).fields(true).build()).collect(Collectors.toList());
    }

    @BuildStep
    ReflectiveClassBuildItem registerGeometryForReflection() {
        return ReflectiveClassBuildItem.builder((String[])new String[]{"com.esri.core.geometry.ogc.OGCGeometry"}).build();
    }

    @BuildStep
    List<ReflectiveClassBuildItem> registerJsonForReflection() {
        return Stream.of("com.fasterxml.jackson.core.JsonParser", "com.fasterxml.jackson.databind.ObjectMapper").map(clzName -> ReflectiveClassBuildItem.builder((String[])new String[]{clzName}).build()).collect(Collectors.toList());
    }

    @BuildStep
    List<ReflectiveClassBuildItem> registerReactiveForReflection() {
        return Collections.singletonList(ReflectiveClassBuildItem.builder((String[])new String[]{"org.reactivestreams.Publisher"}).build());
    }

    @BuildStep
    List<ReflectiveClassBuildItem> registerLz4ForReflection(CassandraClientBuildTimeConfig buildTimeConfig) {
        if (buildTimeConfig.protocolCompression.equalsIgnoreCase("lz4")) {
            return Stream.of("net.jpountz.lz4.LZ4Compressor", "net.jpountz.lz4.LZ4JavaSafeCompressor", "net.jpountz.lz4.LZ4HCJavaSafeCompressor", "net.jpountz.lz4.LZ4JavaSafeFastDecompressor", "net.jpountz.lz4.LZ4JavaSafeSafeDecompressor", "net.jpountz.lz4.LZ4JavaUnsafeCompressor", "net.jpountz.lz4.LZ4HCJavaUnsafeCompressor", "net.jpountz.lz4.LZ4JavaUnsafeFastDecompressor", "net.jpountz.lz4.LZ4JavaUnsafeSafeDecompressor").map(clzName -> ReflectiveClassBuildItem.builder((String[])new String[]{clzName}).constructors(true).fields(true).build()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    List<ReflectiveClassBuildItem> registerRequestTrackersForReflection(CassandraClientBuildTimeConfig buildTimeConfig, CassandraClientRecorder recorder, BeanContainerBuildItem beanContainer) {
        return buildTimeConfig.requestTrackers.map(classes -> classes.stream().map(clz -> {
            recorder.addRequestTrackerClass(clz);
            return ReflectiveClassBuildItem.builder((String[])new String[]{clz}).constructors(true).build();
        }).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    List<ReflectiveClassBuildItem> registerNodeStateListenersForReflection(CassandraClientBuildTimeConfig buildTimeConfig, CassandraClientRecorder recorder, BeanContainerBuildItem beanContainer) {
        return buildTimeConfig.nodeStateListeners.map(classes -> classes.stream().map(clz -> {
            recorder.addNodeStateListenerClass(clz);
            return ReflectiveClassBuildItem.builder((String[])new String[]{clz}).constructors(true).build();
        }).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    List<ReflectiveClassBuildItem> registerSchemaChangeListenersForReflection(CassandraClientBuildTimeConfig buildTimeConfig, CassandraClientRecorder recorder, BeanContainerBuildItem beanContainer) {
        return buildTimeConfig.schemaChangeListeners.map(classes -> classes.stream().map(clz -> {
            recorder.addSchemaChangeListenerClass(clz);
            return ReflectiveClassBuildItem.builder((String[])new String[]{clz}).constructors(true).build();
        }).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    @BuildStep
    void setupSslSupport(BuildProducer<ExtensionSslNativeSupportBuildItem> extensionSslNativeSupport) {
        extensionSslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(CASSANDRA_CLIENT));
    }

    @BuildStep
    List<ReflectiveClassBuildItem> registerMetricsFactoriesForReflection(CassandraClientBuildTimeConfig buildTimeConfig, Optional<MetricsCapabilityBuildItem> metricsCapability) {
        if (buildTimeConfig.metricsEnabled && metricsCapability.isPresent()) {
            Stream<String> clzStream = Stream.empty();
            MetricsCapabilityBuildItem metricsCapabilityItem = metricsCapability.get();
            if (metricsCapabilityItem.metricsSupported("micrometer")) {
                clzStream = Stream.of(TaggingMetricIdGenerator.class.getName(), "com.datastax.oss.driver.internal.metrics.micrometer.MicrometerMetricsFactory");
            } else if (metricsCapabilityItem.metricsSupported("smallrye-metrics")) {
                clzStream = Stream.of(TaggingMetricIdGenerator.class.getName(), "com.datastax.oss.driver.internal.metrics.microprofile.MicroProfileMetricsFactory");
            } else {
                LOG.warn("The cassandra-quarkus plugin only supports Micrometer or MicroProfile metrics");
            }
            return clzStream.map(clzName -> ReflectiveClassBuildItem.builder((String[])new String[]{clzName}).methods(true).fields(true).build()).collect(Collectors.toList());
        }
        return Collections.singletonList(ReflectiveClassBuildItem.builder((Class[])new Class[]{DefaultMetricsFactory.class}).build());
    }

    @BuildStep
    UnremovableBeanBuildItem registerMetricsRegistry(Optional<MetricsCapabilityBuildItem> metricsCapability) {
        if (metricsCapability.isPresent()) {
            MetricsCapabilityBuildItem metricsCapabilityItem = metricsCapability.get();
            if (metricsCapabilityItem.metricsSupported("micrometer")) {
                return UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{DotName.createSimple((String)"io.micrometer.core.instrument.MeterRegistry")});
            }
            if (metricsCapabilityItem.metricsSupported("smallrye-metrics")) {
                return UnremovableBeanBuildItem.targetWithAnnotation((DotName)DotName.createSimple((String)"org.eclipse.microprofile.metrics.annotation.RegistryType"));
            }
        }
        return null;
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void configureMetrics(CassandraClientRecorder recorder, CassandraClientBuildTimeConfig buildTimeConfig, Optional<MetricsCapabilityBuildItem> metricsCapability, BeanContainerBuildItem beanContainer) {
        if (buildTimeConfig.metricsEnabled) {
            if (metricsCapability.isPresent()) {
                MetricsCapabilityBuildItem metricsCapabilityItem = metricsCapability.get();
                if (metricsCapabilityItem.metricsSupported("micrometer")) {
                    if (this.checkMicrometerMetricsFactoryPresent()) {
                        recorder.configureMicrometerMetrics();
                    } else {
                        LOG.warn("Micrometer metrics were enabled by configuration, but MicrometerMetricsFactory was not found.");
                        LOG.warn("Make sure to include a dependency to the java-driver-metrics-micrometer module.");
                    }
                } else if (metricsCapabilityItem.metricsSupported("smallrye-metrics")) {
                    if (this.checkMicroProfileMetricsFactoryPresent()) {
                        recorder.configureMicroProfileMetrics();
                    } else {
                        LOG.warn("MicroProfile metrics were enabled by configuration, but MicroProfileMetricsFactory was not found.");
                        LOG.warn("Make sure to include a dependency to the java-driver-metrics-microprofile module.");
                    }
                } else {
                    LOG.warn("Cassandra metrics were enabled by configuration, but the installed metrics capability is not supported.");
                    LOG.warn("Make sure to include a dependency to either quarkus-micrometer-registry-prometheus or quarkus-smallrye-metrics.");
                }
            } else {
                LOG.warn("Cassandra metrics were enabled by configuration, but no metrics capability is installed.");
                LOG.warn("Make sure to include a dependency to either quarkus-micrometer-registry-prometheus or quarkus-smallrye-metrics.");
            }
        } else {
            LOG.info("Cassandra metrics were disabled by configuration.");
        }
    }

    private boolean checkMicrometerMetricsFactoryPresent() {
        try {
            Class.forName("com.datastax.oss.driver.internal.metrics.micrometer.MicrometerMetricsFactory");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    private boolean checkMicroProfileMetricsFactoryPresent() {
        try {
            Class.forName("com.datastax.oss.driver.internal.metrics.microprofile.MicroProfileMetricsFactory");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void configureCompression(CassandraClientRecorder recorder, CassandraClientBuildTimeConfig buildTimeConfig, BeanContainerBuildItem beanContainer) {
        recorder.configureCompression(buildTimeConfig.protocolCompression);
    }

    @BuildStep
    AdditionalBeanBuildItem cassandraClientProducer() {
        return AdditionalBeanBuildItem.unremovableOf(CassandraClientProducer.class);
    }

    @BuildStep
    AdditionalBeanBuildItem cassandraClientStarter() {
        return AdditionalBeanBuildItem.builder().addBeanClass(CassandraClientStarter.class).build();
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Consume(value=SyntheticBeansRuntimeInitBuildItem.class)
    CassandraClientBuildItem cassandraClient(CassandraClientRecorder recorder, ShutdownContextBuildItem shutdown, BeanContainerBuildItem beanContainer) {
        return new CassandraClientBuildItem((RuntimeValue<CompletionStage<QuarkusCqlSession>>)recorder.buildClient((ShutdownContext)shutdown));
    }

    @BuildStep
    HealthBuildItem addHealthCheck(CassandraClientBuildTimeConfig buildTimeConfig) {
        return new HealthBuildItem("com.datastax.oss.quarkus.runtime.internal.health.CassandraAsyncHealthCheck", buildTimeConfig.healthEnabled);
    }

    @BuildStep
    RuntimeInitializedClassBuildItem runtimeMetadataManager() {
        return new RuntimeInitializedClassBuildItem(MetadataManager.class.getCanonicalName());
    }

    @BuildStep
    RuntimeInitializedClassBuildItem runtimeNative() {
        return new RuntimeInitializedClassBuildItem(Native.class.getCanonicalName());
    }
}

