/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.runtime.internal.context;

import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.session.ProgrammaticArguments;
import com.datastax.oss.driver.internal.core.context.DefaultDriverContext;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.context.NettyOptions;
import com.datastax.oss.driver.internal.core.metrics.MetricsFactory;
import com.datastax.oss.quarkus.runtime.internal.driver.QuarkusNettyOptions;
import com.datastax.oss.quarkus.runtime.internal.metrics.MicroProfileMetricsFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.netty.channel.EventLoopGroup;
import org.eclipse.microprofile.metrics.MetricRegistry;

public class QuarkusDriverContext
extends DefaultDriverContext {
    private final MetricRegistry metricRegistry;
    private final EventLoopGroup quarkusEventLoop;

    public QuarkusDriverContext(@NonNull DriverConfigLoader configLoader, @NonNull ProgrammaticArguments programmaticArguments, @NonNull MetricRegistry metricRegistry, @Nullable EventLoopGroup quarkusEventLoop) {
        super(configLoader, programmaticArguments);
        this.metricRegistry = metricRegistry;
        this.quarkusEventLoop = quarkusEventLoop;
    }

    protected MetricsFactory buildMetricsFactory() {
        return new MicroProfileMetricsFactory((InternalDriverContext)this, this.metricRegistry);
    }

    protected NettyOptions buildNettyOptions() {
        if (this.quarkusEventLoop != null) {
            return new QuarkusNettyOptions(this, this.quarkusEventLoop, this.quarkusEventLoop);
        }
        return super.buildNettyOptions();
    }
}

