/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.quarkus.runtime.internal.driver;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.internal.core.context.NettyOptions;
import com.datastax.oss.driver.internal.core.util.concurrent.BlockingOperation;
import com.datastax.oss.driver.shaded.guava.common.util.concurrent.ThreadFactoryBuilder;
import com.datastax.oss.quarkus.runtime.internal.context.QuarkusDriverContext;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.internal.PlatformDependent;
import java.time.Duration;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuarkusNettyOptions
implements NettyOptions {
    private static final Logger LOG = LoggerFactory.getLogger(QuarkusNettyOptions.class);
    private final DriverExecutionProfile config;
    private final EventLoopGroup ioEventLoopGroup;
    private final EventLoopGroup adminEventLoopGroup;
    private final Timer timer;

    public QuarkusNettyOptions(QuarkusDriverContext context, EventLoopGroup ioEventLoopGroup, EventLoopGroup adminEventLoopGroup) {
        this.config = context.getConfig().getDefaultProfile();
        boolean daemon = this.config.getBoolean((DriverOption)DefaultDriverOption.NETTY_DAEMON);
        BlockingOperation.SafeThreadFactory safeFactory = new BlockingOperation.SafeThreadFactory();
        this.ioEventLoopGroup = ioEventLoopGroup;
        this.adminEventLoopGroup = adminEventLoopGroup;
        ThreadFactory timerThreadFactory = new ThreadFactoryBuilder().setThreadFactory((ThreadFactory)safeFactory).setNameFormat(context.getSessionName() + "-timer-%d").setDaemon(daemon).build();
        Duration tickDuration = this.config.getDuration((DriverOption)DefaultDriverOption.NETTY_TIMER_TICK_DURATION);
        if (PlatformDependent.isWindows() && tickDuration.toMillis() < 100L) {
            LOG.warn("Timer tick duration was set to a value too aggressive for Windows: {} ms; doing so is known to cause extreme CPU usage. Please set advanced.netty.timer.tick-duration to 100 ms or higher.", (Object)tickDuration.toMillis());
        }
        this.timer = new HashedWheelTimer(timerThreadFactory, tickDuration.toNanos(), TimeUnit.NANOSECONDS, this.config.getInt((DriverOption)DefaultDriverOption.NETTY_TIMER_TICKS_PER_WHEEL));
    }

    public EventLoopGroup ioEventLoopGroup() {
        return this.ioEventLoopGroup;
    }

    public EventExecutorGroup adminEventExecutorGroup() {
        return this.adminEventLoopGroup;
    }

    public Class<? extends Channel> channelClass() {
        return NioSocketChannel.class;
    }

    public ByteBufAllocator allocator() {
        return ByteBufAllocator.DEFAULT;
    }

    public void afterBootstrapInitialized(Bootstrap bootstrap) {
        boolean tcpNoDelay = this.config.getBoolean((DriverOption)DefaultDriverOption.SOCKET_TCP_NODELAY);
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)tcpNoDelay);
        if (this.config.isDefined((DriverOption)DefaultDriverOption.SOCKET_KEEP_ALIVE)) {
            boolean keepAlive = this.config.getBoolean((DriverOption)DefaultDriverOption.SOCKET_KEEP_ALIVE);
            bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)keepAlive);
        }
        if (this.config.isDefined((DriverOption)DefaultDriverOption.SOCKET_REUSE_ADDRESS)) {
            boolean reuseAddress = this.config.getBoolean((DriverOption)DefaultDriverOption.SOCKET_REUSE_ADDRESS);
            bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)reuseAddress);
        }
        if (this.config.isDefined((DriverOption)DefaultDriverOption.SOCKET_LINGER_INTERVAL)) {
            int lingerInterval = this.config.getInt((DriverOption)DefaultDriverOption.SOCKET_LINGER_INTERVAL);
            bootstrap.option(ChannelOption.SO_LINGER, (Object)lingerInterval);
        }
        if (this.config.isDefined((DriverOption)DefaultDriverOption.SOCKET_RECEIVE_BUFFER_SIZE)) {
            int receiveBufferSize = this.config.getInt((DriverOption)DefaultDriverOption.SOCKET_RECEIVE_BUFFER_SIZE);
            ((Bootstrap)bootstrap.option(ChannelOption.SO_RCVBUF, (Object)receiveBufferSize)).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(receiveBufferSize));
        }
        if (this.config.isDefined((DriverOption)DefaultDriverOption.SOCKET_SEND_BUFFER_SIZE)) {
            int sendBufferSize = this.config.getInt((DriverOption)DefaultDriverOption.SOCKET_SEND_BUFFER_SIZE);
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)sendBufferSize);
        }
        if (this.config.isDefined((DriverOption)DefaultDriverOption.CONNECTION_CONNECT_TIMEOUT)) {
            Duration connectTimeout = this.config.getDuration((DriverOption)DefaultDriverOption.CONNECTION_CONNECT_TIMEOUT);
            bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Long.valueOf(connectTimeout.toMillis()).intValue());
        }
    }

    public void afterChannelInitialized(Channel channel) {
    }

    public Future<Void> onClose() {
        DefaultPromise promise = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
        promise.setSuccess(null);
        return promise;
    }

    public synchronized Timer getTimer() {
        return this.timer;
    }
}

